/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;

public interface ConfigNode {
    public static final ThreadLocal<Function<String, String>> SUBSTITUTES;
    public static final ConfigNode EMPTY;

    public String name();

    public Map<String, String> attributes();

    default public Map<String, String> attributesExcept(String ... exclusions) {
        if (!2.$assertionsDisabled && exclusions.length >= 5) {
            throw new AssertionError((Object)"non-performant exclusion list");
        }
        Map<String, String> attributes = this.attributes();
        HashMap<String, String> args = CollectionUtil.newHashMap(attributes.size());
        attributes.forEach((k, v) -> {
            for (String ex : exclusions) {
                if (!ex.equals(k)) continue;
                return;
            }
            args.put((String)k, (String)v);
        });
        return args;
    }

    default public ConfigNode child(String name) {
        return this.child(name, null);
    }

    default public ConfigNode get(String name) {
        ConfigNode child = this.child(name, null);
        return child == null ? EMPTY : child;
    }

    default public ConfigNode get(String name, Predicate<ConfigNode> test) {
        List<ConfigNode> children = this.getAll(Set.of(name), test);
        if (children.isEmpty()) {
            return EMPTY;
        }
        return children.get(0);
    }

    default public ConfigNode get(String name, int idx) {
        List<ConfigNode> children = this.getAll(name);
        if (idx < children.size()) {
            return children.get(idx);
        }
        return EMPTY;
    }

    default public ConfigNode childRequired(String name, Supplier<RuntimeException> err) {
        ConfigNode n = this.child(name);
        if (n == null) {
            throw err.get();
        }
        return n;
    }

    default public boolean boolVal(boolean def) {
        return Helpers._bool(this.txt(), def);
    }

    default public int intVal(int def) {
        return Helpers._int(this.txt(), def);
    }

    default public String attr(String name, String def) {
        return Helpers._txt(this.attributes().get(name), def);
    }

    default public String attr(String name) {
        return this.attributes().get(name);
    }

    default public String attrRequired(String name, String missingErr) {
        if (!2.$assertionsDisabled && missingErr == null) {
            throw new AssertionError();
        }
        String attr = this.attr(name);
        if (attr == null) {
            throw new RuntimeException(missingErr + ": missing mandatory attribute '" + name + "'");
        }
        return attr;
    }

    default public int intAttr(String name, int def) {
        return Helpers._int(this.attr(name), def);
    }

    default public boolean boolAttr(String name, boolean def) {
        return Helpers._bool(this.attr(name), def);
    }

    default public String txt(String def) {
        return this.txt() == null ? def : this.txt();
    }

    public String txt();

    default public double doubleVal(double def) {
        return Helpers._double(this.txt(), def);
    }

    default public ConfigNode child(String name, Predicate<ConfigNode> test) {
        ConfigNode[] result = new ConfigNode[1];
        this.forEachChild(it -> {
            if (name != null && !name.equals(it.name())) {
                return Boolean.TRUE;
            }
            if (test == null || test.test((ConfigNode)it)) {
                result[0] = it;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        return result[0];
    }

    default public List<ConfigNode> getAll(Set<String> names, Predicate<ConfigNode> test) {
        if (!2.$assertionsDisabled && names != null && names.isEmpty()) {
            throw new AssertionError((Object)"Intended to pass null?");
        }
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        this.forEachChild(it -> {
            if ((names == null || names.contains(it.name())) && (test == null || test.test((ConfigNode)it))) {
                result.add((ConfigNode)it);
            }
            return Boolean.TRUE;
        });
        return result;
    }

    default public List<ConfigNode> getAll(String name) {
        return this.getAll(Set.of(name), null);
    }

    default public boolean exists() {
        return true;
    }

    default public boolean isNull() {
        return false;
    }

    public void forEachChild(Function<ConfigNode, Boolean> var1);

    default public NamedList<Object> childNodesToNamedList() {
        NamedList<Object> result = new NamedList<Object>();
        this.forEachChild(it -> {
            String tag = it.name();
            String varName = it.attributes().get("name");
            if (DOMUtil.NL_TAGS.contains(tag)) {
                result.add(varName, DOMUtil.parseVal(tag, varName, it.txt()));
            }
            if ("lst".equals(tag)) {
                result.add(varName, it.childNodesToNamedList());
            } else if ("arr".equals(tag)) {
                ArrayList l = new ArrayList();
                result.add(varName, l);
                it.forEachChild(n -> {
                    if (DOMUtil.NL_TAGS.contains(n.name())) {
                        l.add(DOMUtil.parseVal(n.name(), null, n.txt()));
                    } else if ("lst".equals(n.name())) {
                        l.add(n.childNodesToNamedList());
                    }
                    return Boolean.TRUE;
                });
            }
            return Boolean.TRUE;
        });
        return result;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        SUBSTITUTES = new ThreadLocal();
        EMPTY = new ConfigNode(){

            @Override
            public String name() {
                return null;
            }

            @Override
            public String txt() {
                return null;
            }

            @Override
            public Map<String, String> attributes() {
                return Map.of();
            }

            @Override
            public String attr(String name) {
                return null;
            }

            @Override
            public String attr(String name, String def) {
                return def;
            }

            @Override
            public ConfigNode child(String name) {
                return null;
            }

            @Override
            public ConfigNode get(String name) {
                return EMPTY;
            }

            @Override
            public boolean exists() {
                return false;
            }

            @Override
            public boolean isNull() {
                return true;
            }

            @Override
            public void forEachChild(Function<ConfigNode, Boolean> fun) {
            }
        };
    }

    public static class Helpers {
        static boolean _bool(Object v, boolean def) {
            return v == null ? def : Boolean.parseBoolean(v.toString());
        }

        static String _txt(Object v, String def) {
            return v == null ? def : v.toString();
        }

        static int _int(Object v, int def) {
            return v == null ? def : Integer.parseInt(v.toString());
        }

        static double _double(Object v, double def) {
            return v == null ? def : Double.parseDouble(v.toString());
        }

        public static Predicate<ConfigNode> at(final int i) {
            return new Predicate<ConfigNode>(){
                int index = 0;

                @Override
                public boolean test(ConfigNode node) {
                    if (this.index == i) {
                        return true;
                    }
                    ++this.index;
                    return false;
                }
            };
        }
    }
}

