/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.jwt;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTIssuerConfig {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String PARAM_ISS_NAME = "name";
    static final String PARAM_JWKS_URL = "jwksUrl";
    static final String PARAM_JWK = "jwk";
    static final String PARAM_ISSUER = "iss";
    static final String PARAM_AUDIENCE = "aud";
    static final String PARAM_WELL_KNOWN_URL = "wellKnownUrl";
    static final String PARAM_AUTHORIZATION_ENDPOINT = "authorizationEndpoint";
    static final String PARAM_TOKEN_ENDPOINT = "tokenEndpoint";
    static final String PARAM_CLIENT_ID = "clientId";
    static final String PARAM_AUTHORIZATION_FLOW = "authorizationFlow";
    private static HttpsJwksFactory httpsJwksFactory = new HttpsJwksFactory(3600L, 5000L);
    private String iss;
    private String aud;
    private JsonWebKeySet jsonWebKeySet;
    private String name;
    private List<String> jwksUrl;
    private List<HttpsJwks> httpsJwks;
    private String wellKnownUrl;
    private WellKnownDiscoveryConfig wellKnownDiscoveryConfig;
    private String clientId;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String authorizationFlow;
    private Collection<X509Certificate> trustedCerts;
    public static boolean ALLOW_OUTBOUND_HTTP = Boolean.parseBoolean(EnvUtils.getProperty((String)"solr.auth.jwt.allowOutboundHttp", (String)"false"));
    public static final String ALLOW_OUTBOUND_HTTP_ERR_MSG = "HTTPS required for IDP communication. Please use SSL or start your nodes with -Dsolr.auth.jwt.allowOutboundHttp=true to allow HTTP for test purposes.";
    private static final String DEFAULT_AUTHORIZATION_FLOW = "implicit";
    private static final Set<String> VALID_AUTHORIZATION_FLOWS = Set.of("implicit", "code_pkce");

    public JWTIssuerConfig(String name) {
        this.name = name;
    }

    public JWTIssuerConfig(Map<String, Object> configMap) {
        this.parseConfigMap(configMap);
    }

    public void init() {
        if (!this.isValid()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration is not valid");
        }
        if (this.wellKnownUrl != null) {
            try {
                this.wellKnownDiscoveryConfig = this.fetchWellKnown(URI.create(this.wellKnownUrl).toURL());
            }
            catch (MalformedURLException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Wrong URL given for well-known endpoint " + this.wellKnownUrl);
            }
            if (this.iss == null) {
                this.iss = this.wellKnownDiscoveryConfig.getIssuer();
            }
            if (this.jwksUrl == null) {
                this.jwksUrl = Collections.singletonList(this.wellKnownDiscoveryConfig.getJwksUrl());
            }
            if (this.authorizationEndpoint == null) {
                this.authorizationEndpoint = this.wellKnownDiscoveryConfig.getAuthorizationEndpoint();
            }
            if (this.tokenEndpoint == null) {
                this.tokenEndpoint = this.wellKnownDiscoveryConfig.getTokenEndpoint();
            }
        }
        if (this.iss == null && this.usesHttpsJwk() && !"PRIMARY".equals(this.name)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required config 'iss' for issuer " + this.getName());
        }
    }

    protected void parseConfigMap(Map<String, Object> configMap) {
        HashMap<String, Object> conf = new HashMap<String, Object>(configMap);
        this.setName((String)conf.get(PARAM_ISS_NAME));
        this.setWellKnownUrl((String)conf.get(PARAM_WELL_KNOWN_URL));
        this.setIss((String)conf.get(PARAM_ISSUER));
        this.setClientId((String)conf.get(PARAM_CLIENT_ID));
        this.setAud((String)conf.get(PARAM_AUDIENCE));
        Object confJwksUrl = conf.get(PARAM_JWKS_URL);
        this.setJwksUrl(confJwksUrl);
        this.setJsonWebKeySet(conf.get(PARAM_JWK));
        this.setAuthorizationEndpoint((String)conf.get(PARAM_AUTHORIZATION_ENDPOINT));
        this.setTokenEndpoint((String)conf.get(PARAM_TOKEN_ENDPOINT));
        this.setAuthorizationFlow((String)conf.get(PARAM_AUTHORIZATION_FLOW));
        conf.remove(PARAM_WELL_KNOWN_URL);
        conf.remove(PARAM_ISSUER);
        conf.remove(PARAM_ISS_NAME);
        conf.remove(PARAM_CLIENT_ID);
        conf.remove(PARAM_AUDIENCE);
        conf.remove(PARAM_JWKS_URL);
        conf.remove(PARAM_JWK);
        conf.remove(PARAM_AUTHORIZATION_ENDPOINT);
        conf.remove(PARAM_TOKEN_ENDPOINT);
        conf.remove(PARAM_AUTHORIZATION_FLOW);
        if (!conf.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration key " + String.valueOf(conf.keySet()) + " for issuer " + this.name);
        }
    }

    protected void setJsonWebKeySet(Object jwksObject) {
        try {
            if (jwksObject != null) {
                this.jsonWebKeySet = JWTIssuerConfig.parseJwkSet((Map)jwksObject);
            }
        }
        catch (JoseException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed parsing parameter 'jwk' for issuer " + this.getName(), (Throwable)e);
        }
    }

    protected static JsonWebKeySet parseJwkSet(Map<String, Object> jwkObj) throws JoseException {
        JsonWebKeySet webKeySet = new JsonWebKeySet(new JsonWebKey[0]);
        if (jwkObj.containsKey("keys")) {
            List jwkList = (List)jwkObj.get("keys");
            for (Object jwkO : jwkList) {
                webKeySet.addJsonWebKey(JsonWebKey.Factory.newJwk((Map)((Map)jwkO)));
            }
        } else {
            webKeySet = new JsonWebKeySet(new JsonWebKey[]{JsonWebKey.Factory.newJwk(jwkObj)});
        }
        return webKeySet;
    }

    private WellKnownDiscoveryConfig fetchWellKnown(URL wellKnownUrl) {
        return WellKnownDiscoveryConfig.parse(wellKnownUrl, this.trustedCerts);
    }

    public String getIss() {
        return this.iss;
    }

    public JWTIssuerConfig setIss(String iss) {
        this.iss = iss;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JWTIssuerConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getWellKnownUrl() {
        return this.wellKnownUrl;
    }

    public JWTIssuerConfig setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
        return this;
    }

    public List<String> getJwksUrls() {
        return this.jwksUrl;
    }

    public JWTIssuerConfig setJwksUrl(List<String> jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    public JWTIssuerConfig setJwksUrl(Object jwksUrlListOrString) {
        if (jwksUrlListOrString instanceof String) {
            this.jwksUrl = Collections.singletonList((String)jwksUrlListOrString);
        } else if (jwksUrlListOrString instanceof List) {
            this.jwksUrl = (List)jwksUrlListOrString;
        } else if (jwksUrlListOrString != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parameter jwksUrl must be either List or String");
        }
        return this;
    }

    public List<HttpsJwks> getHttpsJwks() {
        if (this.httpsJwks == null) {
            this.httpsJwks = httpsJwksFactory.createList(this.getJwksUrls());
        }
        return this.httpsJwks;
    }

    public static void setHttpsJwksFactory(HttpsJwksFactory httpsJwksFactory) {
        JWTIssuerConfig.httpsJwksFactory = httpsJwksFactory;
    }

    public JsonWebKeySet getJsonWebKeySet() {
        return this.jsonWebKeySet;
    }

    public JWTIssuerConfig setJsonWebKeySet(JsonWebKeySet jsonWebKeySet) {
        this.jsonWebKeySet = jsonWebKeySet;
        return this;
    }

    public boolean usesHttpsJwk() {
        return this.getJwksUrls() != null && !this.getJwksUrls().isEmpty();
    }

    public WellKnownDiscoveryConfig getWellKnownDiscoveryConfig() {
        return this.wellKnownDiscoveryConfig;
    }

    public String getAud() {
        return this.aud;
    }

    public JWTIssuerConfig setAud(String aud) {
        this.aud = aud;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public JWTIssuerConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public JWTIssuerConfig setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public JWTIssuerConfig setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public String getAuthorizationFlow() {
        return this.authorizationFlow;
    }

    public JWTIssuerConfig setAuthorizationFlow(String authorizationFlow) {
        String string = this.authorizationFlow = StrUtils.isNullOrEmpty((String)authorizationFlow) ? DEFAULT_AUTHORIZATION_FLOW : authorizationFlow.trim();
        if (!VALID_AUTHORIZATION_FLOWS.contains(this.authorizationFlow)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid value for authorizationFlow. Expected one of " + String.valueOf(VALID_AUTHORIZATION_FLOWS) + " but found " + authorizationFlow);
        }
        if (this.authorizationFlow.equals(DEFAULT_AUTHORIZATION_FLOW)) {
            log.warn("JWT authentication plugin is using 'implicit flow' which is deprecated and less secure. It's recommended to switch to 'code_pkce'");
        }
        return this;
    }

    public Map<String, Object> asConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        this.putIfNotNull(config, PARAM_ISS_NAME, this.name);
        this.putIfNotNull(config, PARAM_ISSUER, this.iss);
        this.putIfNotNull(config, PARAM_AUDIENCE, this.aud);
        this.putIfNotNull(config, PARAM_JWKS_URL, this.jwksUrl);
        this.putIfNotNull(config, PARAM_WELL_KNOWN_URL, this.wellKnownUrl);
        this.putIfNotNull(config, PARAM_CLIENT_ID, this.clientId);
        this.putIfNotNull(config, PARAM_AUTHORIZATION_ENDPOINT, this.authorizationEndpoint);
        this.putIfNotNull(config, PARAM_TOKEN_ENDPOINT, this.tokenEndpoint);
        this.putIfNotNull(config, PARAM_AUTHORIZATION_FLOW, this.authorizationFlow);
        if (this.jsonWebKeySet != null) {
            this.putIfNotNull(config, PARAM_JWK, this.jsonWebKeySet.getJsonWebKeys());
        }
        return config;
    }

    private void putIfNotNull(HashMap<String, Object> config, String paramName, Object value) {
        if (value != null) {
            config.put(paramName, value);
        }
    }

    public boolean isValid() {
        int jwkConfigured = this.wellKnownUrl != null ? 1 : 0;
        jwkConfigured += this.jwksUrl != null ? 2 : 0;
        if ((jwkConfigured += this.jsonWebKeySet != null ? 2 : 0) > 3) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JWTAuthPlugin needs to configure exactly one of wellKnownUrl, jwksUrl and jwk");
        }
        if (jwkConfigured > 0 && this.name == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parameter 'name' is required for issuer configurations");
        }
        return jwkConfigured > 0;
    }

    private static void disableHostVerificationIfLocalhost(URL url, Get httpGet) {
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        if (loopbackAddress.getCanonicalHostName().equals(url.getHost()) || loopbackAddress.getHostName().equals(url.getHost())) {
            httpGet.setHostnameVerifier((hostname, session) -> true);
        }
    }

    public void setTrustedCerts(Collection<X509Certificate> trustedCerts) {
        this.trustedCerts = trustedCerts;
    }

    @VisibleForTesting
    public Collection<X509Certificate> getTrustedCerts() {
        return this.trustedCerts;
    }

    public static void checkAllowOutboundHttpConnections(String parameterName, URL url) {
        if ("http".equalsIgnoreCase(url.getProtocol()) && !ALLOW_OUTBOUND_HTTP) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, parameterName + " is using http protocol. HTTPS required for IDP communication. Please use SSL or start your nodes with -Dsolr.auth.jwt.allowOutboundHttp=true to allow HTTP for test purposes.");
        }
    }

    public static class WellKnownDiscoveryConfig {
        private final Map<String, Object> securityConf;

        WellKnownDiscoveryConfig(Map<String, Object> securityConf) {
            this.securityConf = securityConf;
        }

        public static WellKnownDiscoveryConfig parse(String urlString) throws MalformedURLException {
            return WellKnownDiscoveryConfig.parse(URI.create(urlString).toURL(), null);
        }

        public static WellKnownDiscoveryConfig parse(URL url, Collection<X509Certificate> trustedCerts) {
            try {
                if (!Arrays.asList("https", "file", "http").contains(url.getProtocol())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Well-known config URL must be one of HTTPS or HTTP or file");
                }
                JWTIssuerConfig.checkAllowOutboundHttpConnections(JWTIssuerConfig.PARAM_WELL_KNOWN_URL, url);
                if ("file".equals(url.getProtocol())) {
                    return WellKnownDiscoveryConfig.parse(url.openStream());
                }
                Get httpGet = new Get();
                if (trustedCerts != null) {
                    httpGet.setTrustedCertificates(trustedCerts);
                    JWTIssuerConfig.disableHostVerificationIfLocalhost(url, httpGet);
                }
                SimpleResponse resp = httpGet.get(url.toString());
                return WellKnownDiscoveryConfig.parse(new ByteArrayInputStream(resp.getBody().getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Well-known config could not be read from url " + String.valueOf(url), (Throwable)e);
            }
        }

        @VisibleForTesting
        public static WellKnownDiscoveryConfig parse(String json, Charset charset) {
            return WellKnownDiscoveryConfig.parse(new ByteArrayInputStream(json.getBytes(charset)));
        }

        public static WellKnownDiscoveryConfig parse(InputStream configStream) {
            return new WellKnownDiscoveryConfig((Map)Utils.fromJSON((InputStream)configStream));
        }

        public String getJwksUrl() {
            return (String)this.securityConf.get("jwks_uri");
        }

        public String getIssuer() {
            return (String)this.securityConf.get("issuer");
        }

        public String getAuthorizationEndpoint() {
            return (String)this.securityConf.get("authorization_endpoint");
        }

        public String getUserInfoEndpoint() {
            return (String)this.securityConf.get("userinfo_endpoint");
        }

        public String getTokenEndpoint() {
            return (String)this.securityConf.get("token_endpoint");
        }

        public List<String> getScopesSupported() {
            return (List)this.securityConf.get("scopes_supported");
        }

        public List<String> getResponseTypesSupported() {
            return (List)this.securityConf.get("response_types_supported");
        }
    }

    public static class HttpsJwksFactory {
        private final long jwkCacheDuration;
        private final long refreshReprieveThreshold;
        private Collection<X509Certificate> trustedCerts;

        public HttpsJwksFactory(long jwkCacheDuration, long refreshReprieveThreshold) {
            this.jwkCacheDuration = jwkCacheDuration;
            this.refreshReprieveThreshold = refreshReprieveThreshold;
        }

        public HttpsJwksFactory(long jwkCacheDuration, long refreshReprieveThreshold, Collection<X509Certificate> trustedCerts) {
            this.jwkCacheDuration = jwkCacheDuration;
            this.refreshReprieveThreshold = refreshReprieveThreshold;
            this.trustedCerts = trustedCerts;
        }

        private HttpsJwks create(String url) {
            URL jwksUrl;
            try {
                jwksUrl = URI.create(url).toURL();
                JWTIssuerConfig.checkAllowOutboundHttpConnections(JWTIssuerConfig.PARAM_JWKS_URL, jwksUrl);
            }
            catch (MalformedURLException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Url " + url + " configured in jwksUrl is not a valid URL");
            }
            HttpsJwks httpsJkws = new HttpsJwks(url);
            httpsJkws.setDefaultCacheDuration(this.jwkCacheDuration);
            httpsJkws.setRefreshReprieveThreshold(this.refreshReprieveThreshold);
            if (this.trustedCerts != null) {
                Get getWithCustomTrust = new Get();
                getWithCustomTrust.setTrustedCertificates(this.trustedCerts);
                JWTIssuerConfig.disableHostVerificationIfLocalhost(jwksUrl, getWithCustomTrust);
                httpsJkws.setSimpleHttpGet((SimpleGet)getWithCustomTrust);
            }
            return httpsJkws;
        }

        public List<HttpsJwks> createList(List<String> jwkUrls) {
            return jwkUrls.stream().map(this::create).collect(Collectors.toList());
        }
    }
}

