/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.entries.MagicMatcher;
import com.j256.simplemagic.types.PatternUtils;
import com.j256.simplemagic.types.StringOperator;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringType
implements MagicMatcher {
    private static final Pattern TYPE_PATTERN = Pattern.compile("[^/]+(/\\d+)?(/[BbcwWt]*)?");
    protected static final String EMPTY = "";

    @Override
    public Object convertTestString(String typeStr, String testStr) {
        StringOperator operator;
        Matcher matcher = TYPE_PATTERN.matcher(typeStr);
        if (!matcher.matches()) {
            return new TestInfo(StringOperator.DEFAULT_OPERATOR, testStr, false, false, false, 0);
        }
        int maxOffset = 0;
        String lengthStr = matcher.group(1);
        if (lengthStr != null && lengthStr.length() > 1) {
            try {
                maxOffset = Integer.decode(lengthStr.substring(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid format for search length: " + testStr);
            }
        }
        boolean compactWhiteSpace = false;
        boolean optionalWhiteSpace = false;
        boolean caseInsensitive = false;
        String flagsStr = matcher.group(2);
        if (flagsStr != null) {
            block8: for (char ch : flagsStr.toCharArray()) {
                switch (ch) {
                    case 'B': {
                        compactWhiteSpace = true;
                        continue block8;
                    }
                    case 'b': {
                        optionalWhiteSpace = true;
                        continue block8;
                    }
                    case 'c': {
                        caseInsensitive = true;
                        continue block8;
                    }
                    case 'W': 
                    case 't': 
                    case 'w': {
                        continue block8;
                    }
                }
            }
        }
        if ((operator = StringOperator.fromTest(testStr)) == null) {
            operator = StringOperator.DEFAULT_OPERATOR;
        } else {
            testStr = testStr.substring(1);
        }
        String processedPattern = PatternUtils.preProcessPattern(testStr);
        return new TestInfo(operator, processedPattern, compactWhiteSpace, optionalWhiteSpace, caseInsensitive, maxOffset);
    }

    @Override
    public Object extractValueFromBytes(int offset, byte[] bytes, boolean required) {
        return EMPTY;
    }

    @Override
    public Object isMatch(Object testValue, Long andValue, boolean unsignedType, Object extractedValue, MagicMatcher.MutableOffset mutableOffset, byte[] bytes) {
        return this.findOffsetMatch((TestInfo)testValue, mutableOffset.offset, mutableOffset, bytes, null, bytes.length);
    }

    @Override
    public void renderValue(StringBuilder sb, Object extractedValue, MagicFormatter formatter) {
        formatter.format(sb, extractedValue);
    }

    @Override
    public byte[] getStartingBytes(Object testValue) {
        if (testValue == null) {
            return null;
        }
        return ((TestInfo)testValue).getStartingBytes();
    }

    protected String findOffsetMatch(TestInfo info, int startOffset, MagicMatcher.MutableOffset mutableOffset, byte[] bytes, char[] chars, int maxPos) {
        char[] resultChars;
        if (startOffset < 0) {
            return null;
        }
        int targetPos = startOffset;
        boolean lastMagicCompactWhitespace = false;
        for (int magicPos = 0; magicPos < info.pattern.length(); ++magicPos) {
            boolean lastChar;
            char magicCh = info.pattern.charAt(magicPos);
            boolean bl = lastChar = magicPos == info.pattern.length() - 1;
            if (targetPos >= maxPos) {
                return null;
            }
            char targetCh = bytes == null ? chars[targetPos] : this.charFromByte(bytes, targetPos);
            ++targetPos;
            if (info.operator.doTest(targetCh, magicCh, lastChar)) {
                if (!info.compactWhiteSpace) continue;
                lastMagicCompactWhitespace = Character.isWhitespace(magicCh);
                continue;
            }
            if ((lastMagicCompactWhitespace || info.optionalWhiteSpace) && Character.isWhitespace(targetCh)) {
                while (targetPos < maxPos) {
                    targetCh = bytes == null ? chars[targetPos] : this.charFromByte(bytes, targetPos);
                    ++targetPos;
                    if (Character.isWhitespace(targetCh)) continue;
                }
                if (info.operator.doTest(targetCh, magicCh, lastChar)) {
                    if (!info.compactWhiteSpace) continue;
                    lastMagicCompactWhitespace = Character.isWhitespace(magicCh);
                    continue;
                }
            }
            if (info.caseInsensitive && Character.isLowerCase(magicCh) && info.operator.doTest(Character.toLowerCase(targetCh), magicCh, lastChar)) continue;
            return null;
        }
        if (bytes == null) {
            resultChars = Arrays.copyOfRange(chars, startOffset, targetPos);
        } else {
            resultChars = new char[targetPos - startOffset];
            for (int i = 0; i < resultChars.length; ++i) {
                resultChars[i] = this.charFromByte(bytes, startOffset + i);
            }
        }
        mutableOffset.offset = targetPos;
        return new String(resultChars);
    }

    private char charFromByte(byte[] bytes, int index) {
        return (char)(bytes[index] & 0xFF);
    }

    protected static class TestInfo {
        final StringOperator operator;
        final String pattern;
        final boolean compactWhiteSpace;
        final boolean optionalWhiteSpace;
        final boolean caseInsensitive;
        final int maxOffset;

        public TestInfo(StringOperator operator, String pattern, boolean compactWhiteSpace, boolean optionalWhiteSpace, boolean caseInsensitive, int maxOffset) {
            this.operator = operator;
            this.pattern = pattern;
            this.compactWhiteSpace = compactWhiteSpace;
            this.optionalWhiteSpace = optionalWhiteSpace;
            this.caseInsensitive = caseInsensitive;
            this.maxOffset = maxOffset;
        }

        public byte[] getStartingBytes() {
            if (this.pattern == null || this.pattern.length() < 4) {
                return null;
            }
            return new byte[]{(byte)this.pattern.charAt(0), (byte)this.pattern.charAt(1), (byte)this.pattern.charAt(2), (byte)this.pattern.charAt(3)};
        }

        public String toString() {
            return this.pattern;
        }
    }
}

