/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Optional;
import org.apache.solr.client.api.model.MergeIndexesRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.MergeIndexes;
import org.apache.solr.handler.api.V2ApiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeIndexesOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    MergeIndexesOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        MergeIndexesRequestBody requestBody = new MergeIndexesRequestBody();
        Optional.ofNullable(params.getParams("indexDir")).ifPresent(val -> {
            requestBody.indexDirs = Arrays.asList(val);
        });
        Optional.ofNullable(params.getParams("srcCore")).ifPresent(val -> {
            requestBody.srcCores = Arrays.asList(val);
        });
        requestBody.updateChain = params.get("update.chain");
        MergeIndexes mergeIndexesApi = new MergeIndexes(it.handler.coreContainer, it.handler.coreAdminAsyncTracker, it.req, it.rsp);
        SolrJerseyResponse response = mergeIndexesApi.mergeIndexes(cname, requestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    }
}

