/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class ToolEntry
extends PaletteEntry {
    public static final Object PALETTE_TYPE_TOOL = "$Palette Tool";
    private Map<Object, Object> map;
    private Class<? extends Tool> toolClass;

    public ToolEntry(String label, String shortDesc, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
        this(label, shortDesc, iconSmall, iconLarge, null);
    }

    public ToolEntry(String label, String description, ImageDescriptor iconSmall, ImageDescriptor iconLarge, Class<? extends Tool> tool) {
        super(label, description, iconSmall, iconLarge, PALETTE_TYPE_TOOL);
        this.setToolClass(tool);
    }

    public Tool createTool() {
        Tool tool;
        if (this.toolClass == null) {
            return null;
        }
        try {
            tool = this.toolClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
        tool.setProperties(this.getToolProperties());
        return tool;
    }

    protected Map getToolProperties() {
        return this.map;
    }

    public Object getToolProperty(Object key) {
        if (this.map != null) {
            return this.map.get(key);
        }
        return null;
    }

    public void setToolClass(Class<? extends Tool> toolClass) {
        this.toolClass = toolClass;
    }

    public void setToolProperty(Object key, Object value) {
        if (this.map == null) {
            this.map = new HashMap<Object, Object>();
        }
        this.map.put(key, value);
    }
}

