import { type StyledChar } from '@alcalzone/ansi-tokenize';
import { type DOMElement, type DOMNode } from './dom.js';
import type Output from './output.js';
export type OutputTransformer = (s: string, index: number) => string;
export declare const renderNodeToScreenReaderOutput: (node: DOMElement, options?: {
    parentRole?: string;
    skipStaticElements?: boolean;
}) => string;
declare const renderNodeToOutput: (node: DOMElement, output: Output, options: {
    offsetX?: number;
    offsetY?: number;
    transformers?: OutputTransformer[];
    skipStaticElements: boolean;
    nodeToSkip?: DOMElement;
    isStickyRender?: boolean;
    selectionMap?: Map<DOMNode, {
        start: number;
        end: number;
    }>;
    selectionStyle?: (char: StyledChar) => StyledChar;
}) => void;
export default renderNodeToOutput;
