/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;

public class FontStretchManager
extends IdentifierManager {
    protected static final StringMap<Value> values = new StringMap(14);

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 15;
    }

    @Override
    public String getPropertyName() {
        return "font-stretch";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value != null && value.getPrimitiveType() == CSSValue.Type.IDENT) {
            if (value.getIdentifierValue() == "narrower") {
                sm.putParentRelative(idx, true);
                CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
                if (p == null) {
                    return ValueConstants.SEMI_CONDENSED_VALUE;
                }
                Value v = engine.getComputedStyle(p, pseudo, idx);
                if (v != null && v.getPrimitiveType() == CSSValue.Type.IDENT) {
                    String s = v.getIdentifierValue();
                    if (s == "normal") {
                        return ValueConstants.SEMI_CONDENSED_VALUE;
                    }
                    if (s == "condensed") {
                        return ValueConstants.EXTRA_CONDENSED_VALUE;
                    }
                    if (s == "expanded") {
                        return ValueConstants.SEMI_EXPANDED_VALUE;
                    }
                    if (s == "semi-expanded") {
                        return ValueConstants.NORMAL_VALUE;
                    }
                    if (s == "semi-condensed") {
                        return ValueConstants.CONDENSED_VALUE;
                    }
                    if (s == "extra-condensed") {
                        return ValueConstants.ULTRA_CONDENSED_VALUE;
                    }
                    if (s == "extra-expanded") {
                        return ValueConstants.EXPANDED_VALUE;
                    }
                    if (s == "ultra-condensed") {
                        return ValueConstants.ULTRA_CONDENSED_VALUE;
                    }
                }
                return ValueConstants.EXTRA_EXPANDED_VALUE;
            }
            if (value.getIdentifierValue() == "wider") {
                sm.putParentRelative(idx, true);
                CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
                if (p == null) {
                    return ValueConstants.SEMI_CONDENSED_VALUE;
                }
                Value v = engine.getComputedStyle(p, pseudo, idx);
                if (v != null && v.getPrimitiveType() == CSSValue.Type.IDENT) {
                    String s = v.getIdentifierValue();
                    if (s == "normal") {
                        return ValueConstants.SEMI_EXPANDED_VALUE;
                    }
                    if (s == "condensed") {
                        return ValueConstants.SEMI_CONDENSED_VALUE;
                    }
                    if (s == "expanded") {
                        return ValueConstants.EXTRA_EXPANDED_VALUE;
                    }
                    if (s == "semi-expanded") {
                        return ValueConstants.EXPANDED_VALUE;
                    }
                    if (s == "semi-condensed") {
                        return ValueConstants.NORMAL_VALUE;
                    }
                    if (s == "extra-condensed") {
                        return ValueConstants.CONDENSED_VALUE;
                    }
                    if (s == "extra-expanded") {
                        return ValueConstants.ULTRA_EXPANDED_VALUE;
                    }
                    if (s == "ultra-condensed") {
                        return ValueConstants.EXTRA_CONDENSED_VALUE;
                    }
                }
                return ValueConstants.ULTRA_EXPANDED_VALUE;
            }
        }
        return value;
    }

    @Override
    public StringMap<Value> getIdentifiers() {
        return values;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("condensed", ValueConstants.CONDENSED_VALUE);
        values.put("expanded", ValueConstants.EXPANDED_VALUE);
        values.put("extra-condensed", ValueConstants.EXTRA_CONDENSED_VALUE);
        values.put("extra-expanded", ValueConstants.EXTRA_EXPANDED_VALUE);
        values.put("narrower", ValueConstants.NARROWER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
        values.put("semi-condensed", ValueConstants.SEMI_CONDENSED_VALUE);
        values.put("semi-expanded", ValueConstants.SEMI_EXPANDED_VALUE);
        values.put("ultra-condensed", ValueConstants.ULTRA_CONDENSED_VALUE);
        values.put("ultra-expanded", ValueConstants.ULTRA_EXPANDED_VALUE);
        values.put("wider", ValueConstants.WIDER_VALUE);
    }
}

