/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Invert the intensity of an image.


InvertIntensityImageFilter inverts intensity of pixels by subtracting pixel value to a maximum
value. The maximum value can be set with SetMaximum and defaults the
maximum of input pixel type. This filter can be used to invert, for
example, a binary image, a distance map, etc.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 IntensityWindowingImageFilter ShiftScaleImageFilter

 itk::simple::InvertIntensity for the procedural interface

 itk::InvertIntensityImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInvertIntensityImageFilter.h
*/
public class InvertIntensityImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected InvertIntensityImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.InvertIntensityImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(InvertIntensityImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(InvertIntensityImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::InvertIntensityImageFilter::~InvertIntensityImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_InvertIntensityImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::InvertIntensityImageFilter::InvertIntensityImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  InvertIntensityImageFilter() {
    this(SimpleITKJNI.new_InvertIntensityImageFilter(), true);
  }

  /**
Self&amp; itk::simple::InvertIntensityImageFilter::SetMaximum(double Maximum)

Set/Get the maximum intensity value for the inversion.

*/
public  void setMaximum(double Maximum) {
    SimpleITKJNI.InvertIntensityImageFilter_setMaximum(swigCPtr, this, Maximum);
  }

  /**
double itk::simple::InvertIntensityImageFilter::GetMaximum() const

Set/Get the maximum intensity value for the inversion.

*/
public  double getMaximum() {
    return SimpleITKJNI.InvertIntensityImageFilter_getMaximum(swigCPtr, this);
  }

  /**
std::string itk::simple::InvertIntensityImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.InvertIntensityImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::InvertIntensityImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.InvertIntensityImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::InvertIntensityImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.InvertIntensityImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
