/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cms;

import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.DEROctetString;
import org.python.bouncycastle.asn1.cms.KEKIdentifier;
import org.python.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.python.bouncycastle.asn1.cms.RecipientInfo;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.cms.RecipientInfoGenerator;
import org.python.bouncycastle.operator.GenericKey;
import org.python.bouncycastle.operator.OperatorException;
import org.python.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), (ASN1OctetString)dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

