/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oauth;

import java.io.IOException;
import java.util.Map;
import org.keycloak.broker.oauth.OAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class OAuth2IdentityProviderFactory
extends AbstractIdentityProviderFactory<OAuth2IdentityProvider> {
    public static final String PROVIDER_ID = "oauth2";

    public String getId() {
        return PROVIDER_ID;
    }

    public String getName() {
        return "OAuth v2";
    }

    public OAuth2IdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new OAuth2IdentityProvider(session, this.createConfig(model));
    }

    public IdentityProviderModel createConfig() {
        return this.createConfig(null);
    }

    private OAuth2IdentityProviderConfig createConfig(IdentityProviderModel model) {
        return new OAuth2IdentityProviderConfig(model){

            @Override
            public void validate(RealmModel realm) {
                if (StringUtil.isBlank((String)this.getUserInfoUrl())) {
                    throw new IllegalArgumentException("User Info URL not provided");
                }
                if (StringUtil.isBlank((String)this.getUserIDClaim())) {
                    throw new IllegalArgumentException("User ID Claim not provided");
                }
                if (StringUtil.isBlank((String)this.getUserNameClaim())) {
                    throw new IllegalArgumentException("User Name Claim not provided");
                }
                if (StringUtil.isBlank((String)this.getEmailClaim())) {
                    throw new IllegalArgumentException("User Email Claim not provided");
                }
                super.validate(realm);
            }
        };
    }

    public Map<String, String> parseConfig(KeycloakSession session, String rawConfig) {
        OIDCConfigurationRepresentation rep;
        try {
            rep = (OIDCConfigurationRepresentation)JsonSerialization.readValue((String)rawConfig, OIDCConfigurationRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load openid connect metadata", e);
        }
        OIDCIdentityProviderConfig config = new OIDCIdentityProviderConfig();
        config.setIssuer(rep.getIssuer());
        config.setAuthorizationUrl(rep.getAuthorizationEndpoint());
        config.setTokenUrl(rep.getTokenEndpoint());
        config.setUserInfoUrl(rep.getUserinfoEndpoint());
        if (rep.getIntrospectionEndpoint() != null) {
            config.setTokenIntrospectionUrl(rep.getIntrospectionEndpoint());
        }
        return config.getConfig();
    }
}

