/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.representations.account.OrganizationRepresentation;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.Auth;

public class OrganizationsResource {
    private final KeycloakSession session;
    private final UserModel user;
    private final Auth auth;

    public OrganizationsResource(KeycloakSession session, Auth auth, UserModel user) {
        this.session = session;
        this.auth = auth;
        this.user = user;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getOrganizations() {
        this.auth.requireOneOf("manage-account", "view-profile");
        return Cors.builder().auth().allowedOrigins(this.auth.getToken()).add(Response.ok(((OrganizationProvider)this.session.getProvider(OrganizationProvider.class)).getByMember(this.user).map(this::toRepresentation)));
    }

    private OrganizationRepresentation toRepresentation(OrganizationModel model) {
        OrganizationRepresentation rep = new OrganizationRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getName());
        rep.setAlias(model.getAlias());
        rep.setDescription(model.getDescription());
        rep.setEnabled(model.isEnabled());
        rep.setDomains(model.getDomains().map(OrganizationDomainModel::getName).collect(Collectors.toSet()));
        return rep;
    }
}

