/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.group;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.group.GroupPolicyProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class GroupPolicyProviderFactory
implements PolicyProviderFactory<GroupPolicyRepresentation> {
    public static final String ID = "group";
    private GroupPolicyProvider provider = new GroupPolicyProvider(this::toRepresentation);

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Group";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public GroupPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setGroupsClaim((String)policy.getConfig().get("groupsClaim"));
        try {
            representation.setGroups(this.getGroupsDefinition(policy.getConfig(), authorization));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize groups", cause);
        }
        return representation;
    }

    public Class<GroupPolicyRepresentation> getRepresentationType() {
        return GroupPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, GroupPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation.getGroupsClaim(), representation.getGroups(), authorization);
    }

    public void onUpdate(Policy policy, GroupPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation.getGroupsClaim(), representation.getGroups(), authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        try {
            this.updatePolicy(policy, (String)representation.getConfig().get("groupsClaim"), this.getGroupsDefinition(representation.getConfig(), authorization), authorization);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize groups", cause);
        }
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        HashMap<String, String> config = new HashMap<String, String>();
        GroupPolicyRepresentation groupPolicy = this.toRepresentation(policy, authorization);
        Set groups = groupPolicy.getGroups();
        for (GroupPolicyRepresentation.GroupDefinition definition : groups) {
            GroupModel group = authorization.getRealm().getGroupById(definition.getId());
            if (group == null) continue;
            definition.setId(null);
            definition.setPath(ModelToRepresentation.buildGroupPath((GroupModel)group));
        }
        try {
            String groupsClaim = groupPolicy.getGroupsClaim();
            if (groupsClaim != null) {
                config.put("groupsClaim", groupsClaim);
            }
            config.put("groups", JsonSerialization.writeValueAsString((Object)groups));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to export group policy [" + policy.getName() + "]", cause);
        }
        representation.setConfig(config);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    private void updatePolicy(Policy policy, String groupsClaim, Set<GroupPolicyRepresentation.GroupDefinition> groups, AuthorizationProvider authorization) {
        if (groups == null) {
            throw new RuntimeException("You must provide at least one group");
        }
        HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
        if (groupsClaim != null) {
            config.put("groupsClaim", groupsClaim);
        }
        for (GroupPolicyRepresentation.GroupDefinition definition : groups) {
            GroupModel group = this.getGroup(authorization, definition);
            if (group == null) continue;
            definition.setId(group.getId());
            definition.setPath(null);
        }
        try {
            config.put("groups", JsonSerialization.writeValueAsString(groups));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize groups", cause);
        }
        policy.setConfig(config);
    }

    private GroupModel getGroup(AuthorizationProvider authorization, GroupPolicyRepresentation.GroupDefinition definition) {
        RealmModel realm = authorization.getRealm();
        KeycloakSession session = authorization.getKeycloakSession();
        GroupProvider groups = session.groups();
        if (definition.getId() != null) {
            return realm.getGroupById(definition.getId());
        }
        GroupModel group = null;
        String path = definition.getPath();
        if (path != null) {
            String canonicalPath = path.startsWith("/") ? path.substring(1) : path;
            String[] parts = canonicalPath.split("/");
            GroupModel parent = null;
            for (String part : parts) {
                if (parent == null) {
                    parent = groups.getGroupByName(realm, null, part);
                    if (parent != null) continue;
                    return null;
                }
                group = groups.getGroupByName(realm, parent, part);
                if (group == null) {
                    return null;
                }
                parent = group;
            }
            if (parts.length == 1) {
                group = parent;
            }
        }
        return group;
    }

    private Set<GroupPolicyRepresentation.GroupDefinition> getGroupsDefinition(Map<String, String> config, AuthorizationProvider authorization) throws IOException {
        String groups = config.get("groups");
        if (groups == null) {
            return Collections.emptySet();
        }
        return Arrays.stream((GroupPolicyRepresentation.GroupDefinition[])JsonSerialization.readValue((String)groups, GroupPolicyRepresentation.GroupDefinition[].class)).filter(d -> this.getGroup(authorization, (GroupPolicyRepresentation.GroupDefinition)d) != null).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

