/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.application.preferences.PreferenceMapping;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import com.sun.prism.impl.PrismSettings;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import javafx.scene.paint.Color;

final class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private static final int forcedGtkVersion;
    private static boolean gtkVersionWarningIssued;
    private static final String GTK2_REMOVED_WARNING = "WARNING: A command line option tried to select the GTK 2 library, which was removed from JavaFX.";
    private static final String GTK_INVALID_VERSION_WARNING = "WARNING: A command line option tried to select an invalid GTK library version.";
    private static final String GTK3_FALLBACK_WARNING = "WARNING: The GTK 3 library will be used instead.";
    public static int screen;
    public static long display;
    public static long visualID;
    static float overrideUIScale;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private static final int QUERY_ERROR = -2;
    private static final int QUERY_NO_DISPLAY = -1;
    private static final int QUERY_USE_CURRENT = 1;
    private static final int QUERY_LOAD_GTK3 = 3;
    private Object eventLoopExitEnterPassValue;

    private static float getFloat(String string, float f, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            string3 = System.getenv(string);
        }
        if (string3 == null) {
            return f;
        }
        float f2 = (string3 = string3.trim()).endsWith("%") ? (float)Integer.parseInt(string3.substring(0, string3.length() - 1)) / 100.0f : (string3.endsWith("DPI") || string3.endsWith("dpi") ? (float)Integer.parseInt(string3.substring(0, string3.length() - 3)) / 96.0f : Float.parseFloat(string3));
        if (PrismSettings.verbose) {
            System.out.println(string2 + f2);
        }
        return f2;
    }

    GtkApplication() {
        float f;
        int n;
        int n2 = n = forcedGtkVersion == 0 ? ((Supplier<Integer>)() -> {
            String string = System.getProperty("jdk.gtk.version", "3");
            return Character.getNumericValue(string.charAt(0));
        }).get() : forcedGtkVersion;
        if (n != 3) {
            if (!gtkVersionWarningIssued) {
                if (n == 2) {
                    System.err.println(GTK2_REMOVED_WARNING);
                } else {
                    System.err.println(GTK_INVALID_VERSION_WARNING);
                }
            }
            System.err.println(GTK3_FALLBACK_WARNING);
            gtkVersionWarningIssued = true;
            n = 3;
        }
        boolean bl = Boolean.getBoolean("jdk.gtk.verbose");
        overrideUIScale = PrismSettings.allowHiDPIScaling ? (f = GtkApplication.getFloat("glass.gtk.uiScale", -1.0f, "Forcing UI scaling factor: ")) : -1.0f;
        int n3 = GtkApplication._queryLibrary(n, bl);
        if (n3 == -1) {
            throw new UnsupportedOperationException("Unable to open DISPLAY");
        }
        if (n3 == 1) {
            if (bl) {
                System.out.println("Glass GTK library to load is already loaded");
            }
        } else if (n3 == 3) {
            if (bl) {
                System.out.println("Glass GTK library to load is glassgtk3");
            }
            NativeLibLoader.loadLibrary("glassgtk3");
        } else {
            throw new UnsupportedOperationException("Unable to load glass GTK library.");
        }
        GtkApplication._initGTK(n, bl, overrideUIScale);
        boolean bl2 = Boolean.getBoolean("javafx.embed.isEventThread");
        if (!bl2) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private static native int _queryLibrary(int var0, boolean var1);

    private static native void _initGTK(int var0, boolean var1, float var2);

    private void initDisplay() {
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Object v = map.get("XDisplay");
            if (v != null) {
                display = (Long)v;
            }
            if ((v = map.get("XVisualID")) != null) {
                visualID = (Long)v;
            }
            if ((v = map.get("XScreenID")) != null) {
                screen = (Integer)v;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long l = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long l2 = (Long)map.get("javafx.embed.eventProc");
            l = l2 == null ? 0L : l2;
        }
        boolean bl = Boolean.getBoolean("sun.awt.disablegrab") || Boolean.getBoolean("glass.disableGrab");
        this._init(l, bl);
    }

    @Override
    protected void runLoop(Runnable runnable) {
        boolean bl = Boolean.getBoolean("javafx.embed.isEventThread");
        if (bl) {
            this.init();
            GtkApplication.setEventThread(Thread.currentThread());
            runnable.run();
            return;
        }
        boolean bl2 = Boolean.getBoolean("glass.noErrorTrap");
        Thread thread = new Thread(() -> {
            this.init();
            this._runLoop(runnable, bl2);
        }, "GtkNativeMainLoopThread");
        GtkApplication.setEventThread(thread);
        thread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread thread = GtkApplication.getEventThread();
        if (thread != null) {
            this._terminateLoop();
            GtkApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init(long var1, boolean var3);

    private native void _runLoop(Runnable var1, boolean var2);

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeAndWait(runnable);
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.submitForLaterInvocation(() -> {
                if (runnable != null) {
                    runnable.run();
                }
                countDownLatch.countDown();
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable runnable) {
        this._submitForLaterInvocation(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            this.enterNestedEventLoopImpl();
            Object object = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object2 = object;
            return object2;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this.eventLoopExitEnterPassValue = object;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new GtkWindow(window, screen, n);
    }

    @Override
    public View createView() {
        return new GtkView();
    }

    @Override
    public Cursor createCursor(int n) {
        return new GtkCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new GtkCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return GtkCursor._getBestSize(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new GtkPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer, float f, float f2) {
        return new GtkPixels(n, n2, byteBuffer, f, f2);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new GtkPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f, float f2) {
        return new GtkPixels(n, n2, intBuffer, f, f2);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public GlassRobot createRobot() {
        return new GtkRobot();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        return GtkCommonDialogs.showFileChooser(window, string, string2, string3, n, bl, extensionFilterArray, n2);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return GtkCommonDialogs.showFolderChooser(window, string, string2);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected native boolean _supportsTransparentWindows();

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1, int var2);

    @Override
    protected native int _isKeyLocked(int var1);

    @Override
    public native Map<String, Object> getPlatformPreferences();

    @Override
    public Map<String, PreferenceMapping<?, ?>> getPlatformKeyMappings() {
        return Map.of("GTK.theme_fg_color", new PreferenceMapping("foregroundColor", Color.class), "GTK.theme_bg_color", new PreferenceMapping("backgroundColor", Color.class), "GTK.theme_selected_bg_color", new PreferenceMapping("accentColor", Color.class), "GTK.enable_animations", new PreferenceMapping<Boolean, Boolean>("reducedMotion", Boolean.class, bl -> bl == false), "GTK.overlay_scrolling", new PreferenceMapping<Boolean, Boolean>("persistentScrollBars", Boolean.class, bl -> bl == false), "GTK.network_metered", new PreferenceMapping("reducedData", Boolean.class));
    }

    @Override
    public Map<String, Class<?>> getPlatformKeys() {
        return Map.ofEntries(Map.entry("GTK.theme_name", String.class), Map.entry("GTK.theme_fg_color", Color.class), Map.entry("GTK.theme_bg_color", Color.class), Map.entry("GTK.theme_base_color", Color.class), Map.entry("GTK.theme_selected_bg_color", Color.class), Map.entry("GTK.theme_selected_fg_color", Color.class), Map.entry("GTK.theme_unfocused_fg_color", Color.class), Map.entry("GTK.theme_unfocused_bg_color", Color.class), Map.entry("GTK.theme_unfocused_base_color", Color.class), Map.entry("GTK.theme_unfocused_selected_bg_color", Color.class), Map.entry("GTK.theme_unfocused_selected_fg_color", Color.class), Map.entry("GTK.insensitive_bg_color", Color.class), Map.entry("GTK.insensitive_fg_color", Color.class), Map.entry("GTK.insensitive_base_color", Color.class), Map.entry("GTK.borders", Color.class), Map.entry("GTK.unfocused_borders", Color.class), Map.entry("GTK.warning_color", Color.class), Map.entry("GTK.error_color", Color.class), Map.entry("GTK.success_color", Color.class), Map.entry("GTK.enable_animations", Boolean.class), Map.entry("GTK.overlay_scrolling", Boolean.class), Map.entry("GTK.network_metered", Boolean.class));
    }

    static {
        gtkVersionWarningIssued = false;
        String string = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (string != null && string.contains(".")) {
            PlatformLogger platformLogger = Logging.getJavaFXLogger();
            platformLogger.fine(String.format("SWT-GTK library found. Gtk Version = %s.", string));
            String[] stringArray = string.split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            if (n != 3) {
                throw new UnsupportedOperationException("SWT-GTK uses unsupported major GTK version " + n + " .");
            }
            forcedGtkVersion = n;
        } else {
            forcedGtkVersion = 0;
        }
        Application.loadNativeLibrary();
        screen = -1;
        display = 0L;
        visualID = 0L;
    }
}

