/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import mediathek.gui.messages.DarkModeChangeEvent;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class MemoryUsagePanel
extends JPanel {
    private final TimeSeries total = new TimeSeries((Comparable)((Object)"Total Memory"));
    private final DateAxis domain = new DateAxis("Time");
    private final NumberAxis range = new NumberAxis("Memory");

    public MemoryUsagePanel(int maxAge, @NotNull TimeUnit timeUnit) {
        super(new BorderLayout());
        this.total.setMaximumItemAge(TimeUnit.MILLISECONDS.convert(maxAge, timeUnit));
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.total);
        this.range.setAutoRange(true);
        this.setLabelColors();
        XYSplineRenderer renderer = new XYSplineRenderer();
        renderer.setDefaultShapesVisible(false);
        renderer.setSeriesPaint(0, (Paint)Color.red);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)this.domain, (ValueAxis)this.range, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.BLACK);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.domain.setAutoRange(true);
        this.domain.setLowerMargin(0.0);
        this.domain.setUpperMargin(0.0);
        this.domain.setTickLabelsVisible(true);
        this.range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.range.setNumberFormatOverride((NumberFormat)new DecimalFormat("#######.##"));
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.removeLegend();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPopupMenu(null);
        this.add((Component)chartPanel);
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    @Handler
    private void handleDarkModeChange(DarkModeChangeEvent e) {
        SwingUtilities.invokeLater(this::setLabelColors);
    }

    private void setLabelColors() {
        Color color = UIManager.getColor("Label.foreground");
        this.domain.setLabelPaint((Paint)color);
        this.domain.setTickLabelPaint((Paint)color);
        this.domain.setTickMarkPaint((Paint)color);
        this.range.setLabelPaint((Paint)color);
        this.range.setTickLabelPaint((Paint)color);
        this.range.setTickMarkPaint((Paint)color);
    }

    private void addTotalObservation(double y) {
        this.total.add((RegularTimePeriod)new Millisecond(), y);
    }

    public class MemoryUsageDataGenerator
    extends Timer
    implements ActionListener {
        public MemoryUsageDataGenerator(@NotNull int interval, TimeUnit timeUnit) {
            super((int)TimeUnit.MILLISECONDS.convert(interval, timeUnit), null);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long t = Runtime.getRuntime().totalMemory() / 0x100000L;
            MemoryUsagePanel.this.addTotalObservation(t);
        }
    }
}

