/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthConstants;

public class TristateCheckBoxIcon
implements Icon,
SynthConstants {
    private UIDefaults.LazyValue _originalIcon;

    public TristateCheckBoxIcon(UIDefaults.LazyValue originalIcon) {
        this._originalIcon = originalIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        if (JdkSpecificClass.isSynthIcon(icon)) {
            int state = this.getComponentState((JComponent)c);
            if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
                state &= 0xFFFFFDFF;
            }
            JdkSpecificClass.paintCheckBoxIcon((JComponent)c, icon, g, state, x, y);
        } else {
            if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)c).getModel()).internalSetSelected(false);
            }
            icon.paintIcon(c, g, x, y);
            if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)c).getModel()).internalSetSelected(true);
            }
        }
        g.setColor(UIManager.getColor("CheckBox.foreground"));
        if (c instanceof TristateCheckBox && ((TristateCheckBox)c).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c).getModel()).isMixed()) {
            this.drawSquare(c, g, x, y);
        }
    }

    private int getComponentState(JComponent c) {
        AbstractButton button;
        ButtonModel model;
        int state = 1;
        if (!c.isEnabled()) {
            state = 8;
        }
        if ((model = (button = (AbstractButton)c).getModel()).isPressed()) {
            state = model.isArmed() ? 4 : 2;
        }
        if (model.isRollover()) {
            state |= 2;
        }
        if (model.isSelected()) {
            state |= 0x200;
        }
        if (c.isFocusOwner() && button.isFocusPainted()) {
            state |= 0x100;
        }
        if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
            state |= 0x400;
        }
        return state;
    }

    @Override
    public int getIconWidth() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconHeight();
    }

    protected void drawSquare(Component c, Graphics g, int x, int y) {
        int w = Math.min(this.getIconWidth(), this.getIconHeight());
        int h = Math.min(this.getIconWidth(), this.getIconHeight());
        int xMargin = w / 3;
        int yMargin = h / 3;
        g.fillRect(x + xMargin, y + yMargin, w - xMargin * 2, h - yMargin * 2);
    }
}

