/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocationAllowedCidrsCopier;
import software.amazon.awssdk.services.ec2.model.IpamPoolAllocationDisallowedCidrsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateIpamPoolCidrRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AllocateIpamPoolCidrRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::dryRun)).setter(AllocateIpamPoolCidrRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::ipamPoolId)).setter(AllocateIpamPoolCidrRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::cidr)).setter(AllocateIpamPoolCidrRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<Integer> NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetmaskLength").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::netmaskLength)).setter(AllocateIpamPoolCidrRequest.setter(Builder::netmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetmaskLength").unmarshallLocationName("NetmaskLength").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::clientToken)).setter(AllocateIpamPoolCidrRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::description)).setter(AllocateIpamPoolCidrRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> PREVIEW_NEXT_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PreviewNextCidr").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::previewNextCidr)).setter(AllocateIpamPoolCidrRequest.setter(Builder::previewNextCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviewNextCidr").unmarshallLocationName("PreviewNextCidr").build()}).build();
    private static final SdkField<List<String>> ALLOWED_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedCidrs").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::allowedCidrs)).setter(AllocateIpamPoolCidrRequest.setter(Builder::allowedCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedCidr").unmarshallLocationName("AllowedCidr").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISALLOWED_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DisallowedCidrs").getter(AllocateIpamPoolCidrRequest.getter(AllocateIpamPoolCidrRequest::disallowedCidrs)).setter(AllocateIpamPoolCidrRequest.setter(Builder::disallowedCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisallowedCidr").unmarshallLocationName("DisallowedCidr").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_POOL_ID_FIELD, CIDR_FIELD, NETMASK_LENGTH_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, PREVIEW_NEXT_CIDR_FIELD, ALLOWED_CIDRS_FIELD, DISALLOWED_CIDRS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AllocateIpamPoolCidrRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPoolId;
    private final String cidr;
    private final Integer netmaskLength;
    private final String clientToken;
    private final String description;
    private final Boolean previewNextCidr;
    private final List<String> allowedCidrs;
    private final List<String> disallowedCidrs;

    private AllocateIpamPoolCidrRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPoolId = builder.ipamPoolId;
        this.cidr = builder.cidr;
        this.netmaskLength = builder.netmaskLength;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.previewNextCidr = builder.previewNextCidr;
        this.allowedCidrs = builder.allowedCidrs;
        this.disallowedCidrs = builder.disallowedCidrs;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final Integer netmaskLength() {
        return this.netmaskLength;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean previewNextCidr() {
        return this.previewNextCidr;
    }

    public final boolean hasAllowedCidrs() {
        return this.allowedCidrs != null && !(this.allowedCidrs instanceof SdkAutoConstructList);
    }

    public final List<String> allowedCidrs() {
        return this.allowedCidrs;
    }

    public final boolean hasDisallowedCidrs() {
        return this.disallowedCidrs != null && !(this.disallowedCidrs instanceof SdkAutoConstructList);
    }

    public final List<String> disallowedCidrs() {
        return this.disallowedCidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.netmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.previewNextCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedCidrs() ? this.allowedCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisallowedCidrs() ? this.disallowedCidrs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateIpamPoolCidrRequest)) {
            return false;
        }
        AllocateIpamPoolCidrRequest other = (AllocateIpamPoolCidrRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.netmaskLength(), other.netmaskLength()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.previewNextCidr(), other.previewNextCidr()) && this.hasAllowedCidrs() == other.hasAllowedCidrs() && Objects.equals(this.allowedCidrs(), other.allowedCidrs()) && this.hasDisallowedCidrs() == other.hasDisallowedCidrs() && Objects.equals(this.disallowedCidrs(), other.disallowedCidrs());
    }

    public final String toString() {
        return ToString.builder((String)"AllocateIpamPoolCidrRequest").add("DryRun", (Object)this.dryRun()).add("IpamPoolId", (Object)this.ipamPoolId()).add("Cidr", (Object)this.cidr()).add("NetmaskLength", (Object)this.netmaskLength()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("PreviewNextCidr", (Object)this.previewNextCidr()).add("AllowedCidrs", this.hasAllowedCidrs() ? this.allowedCidrs() : null).add("DisallowedCidrs", this.hasDisallowedCidrs() ? this.disallowedCidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.netmaskLength()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PreviewNextCidr": {
                return Optional.ofNullable(clazz.cast(this.previewNextCidr()));
            }
            case "AllowedCidrs": {
                return Optional.ofNullable(clazz.cast(this.allowedCidrs()));
            }
            case "DisallowedCidrs": {
                return Optional.ofNullable(clazz.cast(this.disallowedCidrs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPoolId", IPAM_POOL_ID_FIELD);
        map.put("Cidr", CIDR_FIELD);
        map.put("NetmaskLength", NETMASK_LENGTH_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PreviewNextCidr", PREVIEW_NEXT_CIDR_FIELD);
        map.put("AllowedCidr", ALLOWED_CIDRS_FIELD);
        map.put("DisallowedCidr", DISALLOWED_CIDRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllocateIpamPoolCidrRequest, T> g) {
        return obj -> g.apply((AllocateIpamPoolCidrRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPoolId;
        private String cidr;
        private Integer netmaskLength;
        private String clientToken;
        private String description;
        private Boolean previewNextCidr;
        private List<String> allowedCidrs = DefaultSdkAutoConstructList.getInstance();
        private List<String> disallowedCidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateIpamPoolCidrRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPoolId(model.ipamPoolId);
            this.cidr(model.cidr);
            this.netmaskLength(model.netmaskLength);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.previewNextCidr(model.previewNextCidr);
            this.allowedCidrs(model.allowedCidrs);
            this.disallowedCidrs(model.disallowedCidrs);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final Integer getNetmaskLength() {
            return this.netmaskLength;
        }

        public final void setNetmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
        }

        @Override
        public final Builder netmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getPreviewNextCidr() {
            return this.previewNextCidr;
        }

        public final void setPreviewNextCidr(Boolean previewNextCidr) {
            this.previewNextCidr = previewNextCidr;
        }

        @Override
        public final Builder previewNextCidr(Boolean previewNextCidr) {
            this.previewNextCidr = previewNextCidr;
            return this;
        }

        public final Collection<String> getAllowedCidrs() {
            if (this.allowedCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedCidrs;
        }

        public final void setAllowedCidrs(Collection<String> allowedCidrs) {
            this.allowedCidrs = IpamPoolAllocationAllowedCidrsCopier.copy(allowedCidrs);
        }

        @Override
        public final Builder allowedCidrs(Collection<String> allowedCidrs) {
            this.allowedCidrs = IpamPoolAllocationAllowedCidrsCopier.copy(allowedCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedCidrs(String ... allowedCidrs) {
            this.allowedCidrs(Arrays.asList(allowedCidrs));
            return this;
        }

        public final Collection<String> getDisallowedCidrs() {
            if (this.disallowedCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disallowedCidrs;
        }

        public final void setDisallowedCidrs(Collection<String> disallowedCidrs) {
            this.disallowedCidrs = IpamPoolAllocationDisallowedCidrsCopier.copy(disallowedCidrs);
        }

        @Override
        public final Builder disallowedCidrs(Collection<String> disallowedCidrs) {
            this.disallowedCidrs = IpamPoolAllocationDisallowedCidrsCopier.copy(disallowedCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disallowedCidrs(String ... disallowedCidrs) {
            this.disallowedCidrs(Arrays.asList(disallowedCidrs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateIpamPoolCidrRequest build() {
            return new AllocateIpamPoolCidrRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateIpamPoolCidrRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPoolId(String var1);

        public Builder cidr(String var1);

        public Builder netmaskLength(Integer var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder previewNextCidr(Boolean var1);

        public Builder allowedCidrs(Collection<String> var1);

        public Builder allowedCidrs(String ... var1);

        public Builder disallowedCidrs(Collection<String> var1);

        public Builder disallowedCidrs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

