/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import org.opensearch.notifications.core.repackage.com.amazonaws.DefaultRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.Request;
import org.opensearch.notifications.core.repackage.com.amazonaws.SdkClientException;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpMethodName;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.ReceiptFilter;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.ReceiptIpFilter;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Marshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.StringUtils;

public class CreateReceiptFilterRequestMarshaller
implements Marshaller<Request<CreateReceiptFilterRequest>, CreateReceiptFilterRequest> {
    @Override
    public Request<CreateReceiptFilterRequest> marshall(CreateReceiptFilterRequest createReceiptFilterRequest) {
        if (createReceiptFilterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateReceiptFilterRequest> request = new DefaultRequest<CreateReceiptFilterRequest>(createReceiptFilterRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateReceiptFilter");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        ReceiptFilter filter = createReceiptFilterRequest.getFilter();
        if (filter != null) {
            ReceiptIpFilter ipFilter;
            if (filter.getName() != null) {
                request.addParameter("Filter.Name", StringUtils.fromString(filter.getName()));
            }
            if ((ipFilter = filter.getIpFilter()) != null) {
                if (ipFilter.getPolicy() != null) {
                    request.addParameter("Filter.IpFilter.Policy", StringUtils.fromString(ipFilter.getPolicy()));
                }
                if (ipFilter.getCidr() != null) {
                    request.addParameter("Filter.IpFilter.Cidr", StringUtils.fromString(ipFilter.getCidr()));
                }
            }
        }
        return request;
    }
}

