/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import java.util.logging.Level;
import org.greenrobot.eventbus.android.AndroidComponents;

public interface Logger {
    public void log(Level var1, String var2);

    public void log(Level var1, String var2, Throwable var3);

    public static class Default {
        public static Logger get() {
            if (AndroidComponents.areAvailable()) {
                return AndroidComponents.get().logger;
            }
            return new SystemOutLogger();
        }
    }

    public static class SystemOutLogger
    implements Logger {
        @Override
        public void log(Level level, String msg) {
            System.out.println("[" + level + "] " + msg);
        }

        @Override
        public void log(Level level, String msg, Throwable th) {
            System.out.println("[" + level + "] " + msg);
            th.printStackTrace(System.out);
        }
    }

    public static class JavaLogger
    implements Logger {
        protected final java.util.logging.Logger logger;

        public JavaLogger(String tag) {
            this.logger = java.util.logging.Logger.getLogger(tag);
        }

        @Override
        public void log(Level level, String msg) {
            this.logger.log(level, msg);
        }

        @Override
        public void log(Level level, String msg, Throwable th) {
            this.logger.log(level, msg, th);
        }
    }
}

