# CommandParser
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-3)</span>
```pony
class ref CommandParser
```

## Constructors

### create
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-7)</span>


Creates a new parser for a given command spec.


```pony
new box create(
  spec': CommandSpec box)
: CommandParser box^
```
#### Parameters

*   spec': [CommandSpec](cli-CommandSpec.md) box

#### Returns

* [CommandParser](cli-CommandParser.md) box^

---

### _sub
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-14)</span>


```pony
new box _sub(
  spec': CommandSpec box,
  parent': CommandParser box)
: CommandParser box^
```
#### Parameters

*   spec': [CommandSpec](cli-CommandSpec.md) box
*   parent': [CommandParser](cli-CommandParser.md) box

#### Returns

* [CommandParser](cli-CommandParser.md) box^

---

## Public Functions

### parse
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-18)</span>


Parses all of the command line tokens and env vars and returns a Command,
or the first SyntaxError.


```pony
fun box parse(
  argv: Array[String val] box,
  envs: (Array[String val] box | None val) = reference)
: (Command box | CommandHelp box | SyntaxError val)
```
#### Parameters

*   argv: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] box
*   envs: ([Array](builtin-Array.md)\[[String](builtin-String.md) val\] box | [None](builtin-None.md) val) = reference

#### Returns

* ([Command](cli-Command.md) box | [CommandHelp](cli-CommandHelp.md) box | [SyntaxError](cli-SyntaxError.md) val)

---

## Private Functions

### _fullname
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-36)</span>


```pony
fun box _fullname()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### _root_spec
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-43)</span>


```pony
fun box _root_spec()
: CommandSpec box
```

#### Returns

* [CommandSpec](cli-CommandSpec.md) box

---

### _parse_command
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-50)</span>


Parses all of the command line tokens and env vars into the given options
and args maps. Returns the first SyntaxError, or the Command when OK.


```pony
fun box _parse_command(
  tokens: Array[String val] ref,
  options: HashMap[String val, Option val, HashEq[String val] val] ref,
  args: HashMap[String val, Arg val, HashEq[String val] val] ref,
  envsmap: HashMap[String val, String val, HashEq[String val] val] box,
  ostop: Bool val)
: (Command box | CommandHelp box | SyntaxError val)
```
#### Parameters

*   tokens: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] ref
*   options: [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [Option](cli-Option.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] ref
*   args: [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [Arg](cli-Arg.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] ref
*   envsmap: [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [String](builtin-String.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] box
*   ostop: [Bool](builtin-Bool.md) val

#### Returns

* ([Command](cli-Command.md) box | [CommandHelp](cli-CommandHelp.md) box | [SyntaxError](cli-SyntaxError.md) val)

---

### _check_args
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-166)</span>


```pony
fun box _check_args(
  options: HashMap[String val, Option val, HashEq[String val] val] ref,
  args: HashMap[String val, Arg val, HashEq[String val] val] ref,
  envsmap: HashMap[String val, String val, HashEq[String val] val] box,
  arg_pos': USize val)
: (SyntaxError val | USize val)
```
#### Parameters

*   options: [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [Option](cli-Option.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] ref
*   args: [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [Arg](cli-Arg.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] ref
*   envsmap: [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [String](builtin-String.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] box
*   arg_pos': [USize](builtin-USize.md) val

#### Returns

* ([SyntaxError](cli-SyntaxError.md) val | [USize](builtin-USize.md) val)

---

### _parse_long_option
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-224)</span>


--opt=foo => --opt has argument foo
--opt foo => --opt has argument foo, iff arg is required


```pony
fun box _parse_long_option(
  token: String val,
  args: Array[String val] ref)
: (Option val | SyntaxError val)
```
#### Parameters

*   token: [String](builtin-String.md) val
*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] ref

#### Returns

* ([Option](cli-Option.md) val | [SyntaxError](cli-SyntaxError.md) val)

---

### _parse_short_options
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-243)</span>


if 'O' requires an argument
  -OFoo  => -O has argument Foo
  -O=Foo => -O has argument Foo
  -O Foo => -O has argument Foo
else
  -O=Foo => -O has argument foo
-abc => options a, b, c.
-abcFoo => options a, b, c. c has argument Foo iff its arg is required.
-abc=Foo => options a, b, c. c has argument Foo.
-abc Foo => options a, b, c. c has argument Foo iff its arg is required.


```pony
fun box _parse_short_options(
  token: String val,
  args: Array[String val] ref)
: (Array[Option val] ref | SyntaxError val)
```
#### Parameters

*   token: [String](builtin-String.md) val
*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] ref

#### Returns

* ([Array](builtin-Array.md)\[[Option](cli-Option.md) val\] ref | [SyntaxError](cli-SyntaxError.md) val)

---

### _parse_arg
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-293)</span>


```pony
fun box _parse_arg(
  token: String val,
  arg_pos: USize val)
: (Arg val | SyntaxError val)
```
#### Parameters

*   token: [String](builtin-String.md) val
*   arg_pos: [USize](builtin-USize.md) val

#### Returns

* ([Arg](cli-Arg.md) val | [SyntaxError](cli-SyntaxError.md) val)

---

### _option_with_name
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-301)</span>


```pony
fun box _option_with_name(
  name: String val)
: (OptionSpec val | None val)
```
#### Parameters

*   name: [String](builtin-String.md) val

#### Returns

* ([OptionSpec](cli-OptionSpec.md) val | [None](builtin-None.md) val)

---

### _option_with_short
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-311)</span>


```pony
fun box _option_with_short(
  short: U8 val)
: (OptionSpec val | None val)
```
#### Parameters

*   short: [U8](builtin-U8.md) val

#### Returns

* ([OptionSpec](cli-OptionSpec.md) val | [None](builtin-None.md) val)

---

### _short_string
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-323)</span>


```pony
fun tag _short_string(
  c: U8 val)
: String val
```
#### Parameters

*   c: [U8](builtin-U8.md) val

#### Returns

* [String](builtin-String.md) val

---

### _help_name
<span class="source-link">[[Source]](src/cli/command_parser.md#L-0-326)</span>


```pony
fun box _help_name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

