# --------------------------------------------------------------------------
# ⚠️ WARNING - AUTO-GENERATED CODE - DO NOT EDIT ⚠️
# ⚙️ Generated by 'python -m opgen'
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation.
# Licensed under the MIT License.
# --------------------------------------------------------------------------
# pylint: disable=W0221,W0222,R0901,W0237
# mypy: disable-error-code=override
# ruff: noqa: D402
# --------------------------------------------------------------------------

from __future__ import annotations

from typing import Optional, Sequence, Tuple, TypeVar, Union

from onnx.defs import get_schema
from typing_extensions import TypeAlias

from onnxscript.onnx_opset._impl.opset6 import Opset6
from onnxscript.onnx_types import (
    BOOL,
    COMPLEX64,
    COMPLEX128,
    DOUBLE,
    FLOAT,
    FLOAT16,
    INT8,
    INT16,
    INT32,
    INT64,
    STRING,
    UINT8,
    UINT16,
    UINT32,
    UINT64,
)
from onnxscript.values import Op, Opset


class Opset7(Opset6):
    def __new__(cls):
        return Opset.__new__(cls, "", 7)

    T_Acos = TypeVar("T_Acos", DOUBLE, FLOAT, FLOAT16)

    def Acos(self, input: T_Acos) -> T_Acos:
        r"""[🌐 Acos(7)](https://onnx.ai/onnx/operators/onnx__Acos.html#acos-7 "Online Documentation")


        Calculates the arccosine (inverse of cosine) of the given input tensor, element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Acos", 7, "")
        op = Op(self, "Acos", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Add = TypeVar("T_Add", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Add(self, A: T_Add, B: T_Add) -> T_Add:
        r"""[🌐 Add(7)](https://onnx.ai/onnx/operators/onnx__Add.html#add-7 "Online Documentation")


        Performs element-wise binary addition (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First operand.

            B: Second operand.
        """

        schema = get_schema("Add", 7, "")
        op = Op(self, "Add", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_And: TypeAlias = BOOL

    T1_And: TypeAlias = BOOL

    def And(self, A: T_And, B: T_And) -> T1_And:
        r"""[🌐 And(7)](https://onnx.ai/onnx/operators/onnx__And.html#and-7 "Online Documentation")


        Returns the tensor resulted from performing the `and` logical operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: (non-differentiable) First input operand for the logical operator.

            B: (non-differentiable) Second input operand for the logical operator.
        """

        schema = get_schema("And", 7, "")
        op = Op(self, "And", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_Asin = TypeVar("T_Asin", DOUBLE, FLOAT, FLOAT16)

    def Asin(self, input: T_Asin) -> T_Asin:
        r"""[🌐 Asin(7)](https://onnx.ai/onnx/operators/onnx__Asin.html#asin-7 "Online Documentation")


        Calculates the arcsine (inverse of sine) of the given input tensor, element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Asin", 7, "")
        op = Op(self, "Asin", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Atan = TypeVar("T_Atan", DOUBLE, FLOAT, FLOAT16)

    def Atan(self, input: T_Atan) -> T_Atan:
        r"""[🌐 Atan(7)](https://onnx.ai/onnx/operators/onnx__Atan.html#atan-7 "Online Documentation")


        Calculates the arctangent (inverse of tangent) of the given input tensor, element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Atan", 7, "")
        op = Op(self, "Atan", schema)
        return op(*self._prepare_inputs(schema, input))

    T_AveragePool = TypeVar("T_AveragePool", DOUBLE, FLOAT, FLOAT16)

    def AveragePool(
        self,
        X: T_AveragePool,
        *,
        auto_pad: str = "NOTSET",
        count_include_pad: int = 0,
        kernel_shape: Sequence[int],
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_AveragePool:
        r"""[🌐 AveragePool(7)](https://onnx.ai/onnx/operators/onnx__AveragePool.html#averagepool-7 "Online Documentation")


         AveragePool consumes an input tensor X and applies average pooling across
         the tensor according to kernel sizes, stride sizes, and pad lengths.
         average pooling consisting of computing the average on all values of a
         subset of the input tensor according to the kernel size and downsampling the
         data into the output tensor Y for further processing. The output spatial shape will be following:
         ```
         output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

         * pad_shape[i] is sum of pads along axis i
         ```

         `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
         ```
         VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
         SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
         ```
         And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
         ```
         pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
         ```
         The output of each pooling window is divided by the number of elements (exclude pad when attribute count_include_pad is zero).


        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size. Optionally, if dimension denotation is in
                effect, the operation expects the input data tensor to arrive with the
                dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE,
                DATA_FEATURE ...].

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial
                size match the input.In case of odd number add the extra padding at the
                end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no
                padding.

            count_include_pad: Whether include pad pixels when calculating values for
                the edges. Default is 0, doesn't count include pad.

            kernel_shape: The size of the kernel along each axis.

            pads: Padding for the beginning and ending along each spatial axis, it can
                take any value greater than or equal to 0. The value represent the
                number of pixels added to the beginning and end part of the
                corresponding axis. `pads` format should be as follow [x1_begin,
                x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels
                added at the beginning of axis `i` and xi_end, the number of pixels
                added at the end of axis `i`. This attribute cannot be used
                simultaneously with auto_pad attribute. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: Stride along each spatial axis.
        """

        schema = get_schema("AveragePool", 7, "")
        op = Op(self, "AveragePool", schema)
        return op(
            *self._prepare_inputs(schema, X),
            auto_pad=auto_pad,
            count_include_pad=count_include_pad,
            kernel_shape=kernel_shape,
            pads=pads,
            strides=strides,
        )

    T_BatchNormalization = TypeVar("T_BatchNormalization", DOUBLE, FLOAT, FLOAT16)

    def BatchNormalization(
        self,
        X: T_BatchNormalization,
        scale: T_BatchNormalization,
        B: T_BatchNormalization,
        mean: T_BatchNormalization,
        var: T_BatchNormalization,
        *,
        epsilon: float = 9.999999747378752e-06,
        momentum: float = 0.8999999761581421,
        spatial: int = 1,
    ) -> Tuple[
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
    ]:
        r"""[🌐 BatchNormalization(7)](https://onnx.ai/onnx/operators/onnx__BatchNormalization.html#batchnormalization-7 "Online Documentation")


            Carries out batch normalization as described in the paper
            https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
            there are multiple cases for the number of outputs, which we list below:

            Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
            Output case #2: Y (test mode)
                This operator has **optional** inputs/outputs. See `ONNX <https://github.com/onnx/onnx/blob/master/docs/IR.md>`_ for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.


        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size.

            scale: If spatial is true, the dimension of scale is (C). If spatial is
                false, the dimensions of scale are (C x D1 x ... x Dn)

            B: If spatial is true, the dimension of bias is (C). If spatial is false,
                the dimensions of bias are (C x D1 x ... x Dn)

            mean: If spatial is true, the dimension of the running mean (training) or
                the estimated mean (testing) is (C). If spatial is false, the dimensions
                of the running mean (training) or the estimated mean (testing) are (C x
                D1 x ... x Dn).

            var: If spatial is true, the dimension of the running variance(training) or
                the estimated variance (testing) is (C). If spatial is false, the
                dimensions of the running variance(training) or the estimated variance
                (testing) are (C x D1 x ... x Dn).

            epsilon: The epsilon value to use to avoid division by zero.

            momentum: Factor used in computing the running mean and variance.e.g.,
                running_mean = running_mean * momentum + mean * (1 - momentum).

            spatial: If true, compute the mean and variance across per activation. If
                false, compute the mean and variance across per feature over each
                mini-batch.
        """

        schema = get_schema("BatchNormalization", 7, "")
        op = Op(self, "BatchNormalization", schema)
        return op(
            *self._prepare_inputs(schema, X, scale, B, mean, var),
            epsilon=epsilon,
            momentum=momentum,
            spatial=spatial,
        )

    T_Cos = TypeVar("T_Cos", DOUBLE, FLOAT, FLOAT16)

    def Cos(self, input: T_Cos) -> T_Cos:
        r"""[🌐 Cos(7)](https://onnx.ai/onnx/operators/onnx__Cos.html#cos-7 "Online Documentation")


        Calculates the cosine of the given input tensor, element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Cos", 7, "")
        op = Op(self, "Cos", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Div = TypeVar("T_Div", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Div(self, A: T_Div, B: T_Div) -> T_Div:
        r"""[🌐 Div(7)](https://onnx.ai/onnx/operators/onnx__Div.html#div-7 "Online Documentation")


        Performs element-wise binary division (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First operand.

            B: Second operand.
        """

        schema = get_schema("Div", 7, "")
        op = Op(self, "Div", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_Dropout = TypeVar("T_Dropout", DOUBLE, FLOAT, FLOAT16)

    def Dropout(self, data: T_Dropout, *, ratio: float = 0.5) -> Tuple[T_Dropout, T_Dropout]:
        r"""[🌐 Dropout(7)](https://onnx.ai/onnx/operators/onnx__Dropout.html#dropout-7 "Online Documentation")


        Dropout takes one input data (Tensor<float>) and produces two Tensor outputs,
        output (Tensor<float>) and mask (Tensor<bool>). Depending on whether it is in
        test mode or not, the output Y will either be a random dropout, or a simple
        copy of the input. Note that our implementation of Dropout does scaling in
        the training phase, so during testing nothing needs to be done.
        This operator has **optional** inputs/outputs. See `ONNX <https://github.com/onnx/onnx/blob/master/docs/IR.md>`_ for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.


        Args:
            data: The input data as Tensor.

            ratio: The ratio of random dropout
        """

        schema = get_schema("Dropout", 7, "")
        op = Op(self, "Dropout", schema)
        return op(*self._prepare_inputs(schema, data), ratio=ratio)

    T_Equal = TypeVar("T_Equal", BOOL, INT32, INT64)

    T1_Equal: TypeAlias = BOOL

    def Equal(self, A: T_Equal, B: T_Equal) -> T1_Equal:
        r"""[🌐 Equal(7)](https://onnx.ai/onnx/operators/onnx__Equal.html#equal-7 "Online Documentation")


        Returns the tensor resulted from performing the `equal` logical operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First input operand for the logical operator.

            B: Second input operand for the logical operator.
        """

        schema = get_schema("Equal", 7, "")
        op = Op(self, "Equal", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_GRU = TypeVar("T_GRU", DOUBLE, FLOAT, FLOAT16)

    T1_GRU: TypeAlias = INT32

    def GRU(
        self,
        X: T_GRU,
        W: T_GRU,
        R: T_GRU,
        B: Optional[T_GRU] = None,
        sequence_lens: Optional[T1_GRU] = None,
        initial_h: Optional[T_GRU] = None,
        *,
        activation_alpha: Optional[Sequence[float]] = None,
        activation_beta: Optional[Sequence[float]] = None,
        activations: Optional[Sequence[str]] = None,
        clip: Optional[float] = None,
        direction: str = "forward",
        hidden_size: Optional[int] = None,
        linear_before_reset: int = 0,
    ) -> Tuple[T_GRU, T_GRU]:
        r"""[🌐 GRU(7)](https://onnx.ai/onnx/operators/onnx__GRU.html#gru-7 "Online Documentation")


        Computes an one-layer GRU. This operator is usually supported via some custom
        implementation such as CuDNN.

        Notations:

        `X` - input tensor

        `z` - update gate

        `r` - reset gate

        `h` - hidden gate

        `t` - time step (t-1 means previous time step)

        `W[zrh]` - W parameter weight matrix for update, reset, and hidden gates

        `R[zrh]` - R recurrence weight matrix for update, reset, and hidden gates

        `Wb[zrh]` - W bias vectors for update, reset, and hidden gates

        `Rb[zrh]` - R bias vectors for update, reset, and hidden gates

        `WB[zrh]` - W parameter weight matrix for backward update, reset, and hidden gates

        `RB[zrh]` - R recurrence weight matrix for backward update, reset, and hidden gates

        `WBb[zrh]` - W bias vectors for backward update, reset, and hidden gates

        `RBb[zrh]` - R bias vectors for backward update, reset, and hidden gates

        `H` - Hidden state

        `num_directions` - 2 if direction == bidirectional else 1

        Activation functions:

          Relu(x)                - max(0, x)

          Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

          Sigmoid(x)             - 1/(1 + e^{-x})

          (NOTE: Below are optional)

          Affine(x)              - alpha*x + beta

          LeakyRelu(x)           - x if x >= 0 else alpha * x

          ThresholdedRelu(x)     - x if x >= alpha else 0

          ScaledTanh(x)          - alpha*Tanh(beta*x)

          HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

          Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

          Softsign(x)            - x/(1 + |x|)

          Softplus(x)            - log(1 + e^x)

        Equations (Default: f=Sigmoid, g=Tanh):

          - zt = f(Xt*(Wz^T) + Ht-1*(Rz^T) + Wbz + Rbz)

          - rt = f(Xt*(Wr^T) + Ht-1*(Rr^T) + Wbr + Rbr)

          - ht = g(Xt*(Wh^T) + (rt (.) Ht-1)*(Rh^T) + Rbh + Wbh) # default, when linear_before_reset = 0

          - ht = g(Xt*(Wh^T) + (rt (.) (Ht-1*(Rh^T) + Rbh)) + Wbh) # when linear_before_reset != 0

          - Ht = (1 - zt) (.) ht + zt (.) Ht-1
        This operator has **optional** inputs/outputs. See `ONNX <https://github.com/onnx/onnx/blob/master/docs/IR.md>`_ for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.


        Args:
            X: The input sequences packed (and potentially padded) into one 3-D tensor
                with the shape of `[seq_length, batch_size, input_size]`.

            W: The weight tensor for the gates. Concatenation of `W[zrh]` and `WB[zrh]`
                (if bidirectional) along dimension 0. This tensor has shape
                `[num_directions, 3*hidden_size, input_size]`.

            R: The recurrence weight tensor. Concatenation of `R[zrh]` and `RB[zrh]` (if
                bidirectional) along dimension 0. This tensor has shape
                `[num_directions, 3*hidden_size, hidden_size]`.

            B: (optional) The bias tensor for the gates. Concatenation of `[Wb[zrh],
                Rb[zrh]]` and `[WBb[zrh], RBb[zrh]]` (if bidirectional) along dimension
                0. This tensor has shape `[num_directions, 6*hidden_size]`. Optional: If
                not specified - assumed to be 0

            sequence_lens: (optional) Optional tensor specifying lengths of the
                sequences in a batch. If not specified - assumed all sequences in the
                batch to have length `seq_length`. It has shape `[batch_size]`.

            initial_h: (optional) Optional initial value of the hidden. If not specified
                - assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            activation_alpha: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.For example with LeakyRelu, the default
                alpha is 0.01.

            activation_beta: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.

            activations: A list of 2 (or 4 if bidirectional) activation functions for
                update, reset, and hidden gates. The activation functions must be one of
                the activation functions specified above. Optional: See the equations
                for default if not specified.

            clip: Cell clip threshold. Clipping bounds the elements of a tensor in the
                range of [-threshold, +threshold] and is applied to the input of
                activations. No clip if not specified.

            direction: Specify if the RNN is forward, reverse, or bidirectional. Must be
                one of forward (default), reverse, or bidirectional.

            hidden_size: Number of neurons in the hidden layer

            linear_before_reset: When computing the output of the hidden gate, apply the
                linear transformation before multiplying by the output of the reset
                gate.
        """

        schema = get_schema("GRU", 7, "")
        op = Op(self, "GRU", schema)
        return op(
            *self._prepare_inputs(schema, X, W, R, B, sequence_lens, initial_h),
            activation_alpha=activation_alpha,
            activation_beta=activation_beta,
            activations=activations,
            clip=clip,
            direction=direction,
            hidden_size=hidden_size,
            linear_before_reset=linear_before_reset,
        )

    T_Gemm = TypeVar("T_Gemm", DOUBLE, FLOAT, FLOAT16)

    def Gemm(
        self,
        A: T_Gemm,
        B: T_Gemm,
        C: T_Gemm,
        *,
        alpha: float = 1.0,
        beta: float = 1.0,
        transA: int = 0,
        transB: int = 0,
    ) -> T_Gemm:
        r"""[🌐 Gemm(7)](https://onnx.ai/onnx/operators/onnx__Gemm.html#gemm-7 "Online Documentation")

        General Matrix multiplication:
        https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3

        A' = transpose(A) if transA else A

        B' = transpose(B) if transB else B

        Compute Y = alpha * A' * B' + beta * C, where input tensor A has shape (M, K) or (K, M),
        input tensor B has shape (K, N) or (N, K), input tensor C is broadcastable to shape (M, N),
        and output tensor Y has shape (M, N). A will be transposed before doing the
        computation if attribute transA is non-zero, same for B and transB.
        This operator supports **unidirectional broadcasting** (tensor C should be unidirectional broadcastable to tensor A * B); for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.

        Args:
            A: Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M)
                if transA is non-zero.

            B: Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K)
                if transB is non-zero.

            C: Input tensor C. The shape of C should be unidirectional broadcastable to
                (M, N).

            alpha: Scalar multiplier for the product of input tensors A * B.

            beta: Scalar multiplier for input tensor C.

            transA: Whether A should be transposed

            transB: Whether B should be transposed
        """

        schema = get_schema("Gemm", 7, "")
        op = Op(self, "Gemm", schema)
        return op(
            *self._prepare_inputs(schema, A, B, C),
            alpha=alpha,
            beta=beta,
            transA=transA,
            transB=transB,
        )

    T_Greater = TypeVar("T_Greater", DOUBLE, FLOAT, FLOAT16)

    T1_Greater: TypeAlias = BOOL

    def Greater(self, A: T_Greater, B: T_Greater) -> T1_Greater:
        r"""[🌐 Greater(7)](https://onnx.ai/onnx/operators/onnx__Greater.html#greater-7 "Online Documentation")


        Returns the tensor resulted from performing the `greater` logical operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First input operand for the logical operator.

            B: Second input operand for the logical operator.
        """

        schema = get_schema("Greater", 7, "")
        op = Op(self, "Greater", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_LSTM = TypeVar("T_LSTM", DOUBLE, FLOAT, FLOAT16)

    T1_LSTM: TypeAlias = INT32

    def LSTM(
        self,
        X: T_LSTM,
        W: T_LSTM,
        R: T_LSTM,
        B: Optional[T_LSTM] = None,
        sequence_lens: Optional[T1_LSTM] = None,
        initial_h: Optional[T_LSTM] = None,
        initial_c: Optional[T_LSTM] = None,
        P: Optional[T_LSTM] = None,
        *,
        activation_alpha: Optional[Sequence[float]] = None,
        activation_beta: Optional[Sequence[float]] = None,
        activations: Optional[Sequence[str]] = None,
        clip: Optional[float] = None,
        direction: str = "forward",
        hidden_size: Optional[int] = None,
        input_forget: int = 0,
    ) -> Tuple[T_LSTM, T_LSTM, T_LSTM]:
        r"""[🌐 LSTM(7)](https://onnx.ai/onnx/operators/onnx__LSTM.html#lstm-7 "Online Documentation")


        Computes an one-layer LSTM. This operator is usually supported via some
        custom implementation such as CuDNN.

        Notations:

        `X` - input tensor

        `i` - input gate

        `o` - output gate

        `f` - forget gate

        `c` - cell gate

        `t` - time step (t-1 means previous time step)

        `W[iofc]` - W parameter weight matrix for input, output, forget, and cell gates

        `R[iofc]` - R recurrence weight matrix for input, output, forget, and cell gates

        `Wb[iofc]` - W bias vectors for input, output, forget, and cell gates

        `Rb[iofc]` - R bias vectors for input, output, forget, and cell gates

        `P[iof]`  - P peephole weight vector for input, output, and forget gates

        `WB[iofc]` - W parameter weight matrix for backward input, output, forget, and cell gates

        `RB[iofc]` - R recurrence weight matrix for backward input, output, forget, and cell gates

        `WBb[iofc]` - W bias vectors for backward input, output, forget, and cell gates

        `RBb[iofc]` - R bias vectors for backward input, output, forget, and cell gates

        `PB[iof]`  - P peephole weight vector for backward input, output, and forget gates

        `H` - Hidden state

        `num_directions` - 2 if direction == bidirectional else 1

        Activation functions:

          Relu(x)                - max(0, x)

          Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

          Sigmoid(x)             - 1/(1 + e^{-x})

          (NOTE: Below are optional)

          Affine(x)              - alpha*x + beta

          LeakyRelu(x)           - x if x >= 0 else alpha * x

          ThresholdedRelu(x)     - x if x >= alpha else 0

          ScaledTanh(x)          - alpha*Tanh(beta*x)

          HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

          Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

          Softsign(x)            - x/(1 + |x|)

          Softplus(x)            - log(1 + e^x)

        Equations (Default: f=Sigmoid, g=Tanh, h=Tanh):

          - it = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Pi (.) Ct-1 + Wbi + Rbi)

          - ft = f(Xt*(Wf^T) + Ht-1*(Rf^T) + Pf (.) Ct-1 + Wbf + Rbf)

          - ct = g(Xt*(Wc^T) + Ht-1*(Rc^T) + Wbc + Rbc)

          - Ct = ft (.) Ct-1 + it (.) ct

          - ot = f(Xt*(Wo^T) + Ht-1*(Ro^T) + Po (.) Ct + Wbo + Rbo)

          - Ht = ot (.) h(Ct)
        This operator has **optional** inputs/outputs. See `ONNX <https://github.com/onnx/onnx/blob/master/docs/IR.md>`_ for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.


        Args:
            X: The input sequences packed (and potentially padded) into one 3-D tensor
                with the shape of `[seq_length, batch_size, input_size]`.

            W: The weight tensor for the gates. Concatenation of `W[iofc]` and
                `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape
                `[num_directions, 4*hidden_size, input_size]`.

            R: The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]`
                (if bidirectional) along dimension 0. This tensor has shape
                `[num_directions, 4*hidden_size, hidden_size]`.

            B: (optional) The bias tensor for input gate. Concatenation of `[Wb[iofc],
                Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along
                dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`.
                Optional: If not specified - assumed to be 0.

            sequence_lens: (optional) Optional tensor specifying lengths of the
                sequences in a batch. If not specified - assumed all sequences in the
                batch to have length `seq_length`. It has shape `[batch_size]`.

            initial_h: (optional) Optional initial value of the hidden. If not specified
                - assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            initial_c: (optional) Optional initial value of the cell. If not specified -
                assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            P: (optional) The weight tensor for peepholes. Concatenation of `P[iof]` and
                `PB[iof]` (if bidirectional) along dimension 0. It has shape
                `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed
                to be 0.

            activation_alpha: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.For example with LeakyRelu, the default
                alpha is 0.01.

            activation_beta: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.

            activations: A list of 3 (or 6 if bidirectional) activation functions for
                input, output, forget, cell, and hidden. The activation functions must
                be one of the activation functions specified above. Optional: See the
                equations for default if not specified.

            clip: Cell clip threshold. Clipping bounds the elements of a tensor in the
                range of [-threshold, +threshold] and is applied to the input of
                activations. No clip if not specified.

            direction: Specify if the RNN is forward, reverse, or bidirectional. Must be
                one of forward (default), reverse, or bidirectional.

            hidden_size: Number of neurons in the hidden layer

            input_forget: Couple the input and forget gates if 1.
        """

        schema = get_schema("LSTM", 7, "")
        op = Op(self, "LSTM", schema)
        return op(
            *self._prepare_inputs(schema, X, W, R, B, sequence_lens, initial_h, initial_c, P),
            activation_alpha=activation_alpha,
            activation_beta=activation_beta,
            activations=activations,
            clip=clip,
            direction=direction,
            hidden_size=hidden_size,
            input_forget=input_forget,
        )

    T_Less = TypeVar("T_Less", DOUBLE, FLOAT, FLOAT16)

    T1_Less: TypeAlias = BOOL

    def Less(self, A: T_Less, B: T_Less) -> T1_Less:
        r"""[🌐 Less(7)](https://onnx.ai/onnx/operators/onnx__Less.html#less-7 "Online Documentation")


        Returns the tensor resulted from performing the `less` logical operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First input operand for the logical operator.

            B: Second input operand for the logical operator.
        """

        schema = get_schema("Less", 7, "")
        op = Op(self, "Less", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_Mul = TypeVar("T_Mul", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Mul(self, A: T_Mul, B: T_Mul) -> T_Mul:
        r"""[🌐 Mul(7)](https://onnx.ai/onnx/operators/onnx__Mul.html#mul-7 "Online Documentation")


        Performs element-wise binary multiplication (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First operand.

            B: Second operand.
        """

        schema = get_schema("Mul", 7, "")
        op = Op(self, "Mul", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T1_Multinomial = TypeVar("T1_Multinomial", DOUBLE, FLOAT, FLOAT16)

    T2_Multinomial: TypeAlias = Union[INT32, INT64]

    def Multinomial(
        self,
        input: T1_Multinomial,
        *,
        dtype: int = 6,
        sample_size: int = 1,
        seed: Optional[float] = None,
    ) -> T2_Multinomial:
        r"""[🌐 Multinomial(7)](https://onnx.ai/onnx/operators/onnx__Multinomial.html#multinomial-7 "Online Documentation")


        Generate a tensor of samples from a multinomial distribution according to the probabilities
        of each of the possible outcomes.


        Args:
            input: Input tensor with shape [batch_size, class_size], where class_size is
                the number of all possible outcomes. Each value along the axis zero
                represents the unnormalized log-probability of each corresponding
                outcome in a batch.

            dtype: (Optional) The data type for the elements of the output tensor, if
                not specified, we will use int32.

            sample_size: Number of times to sample.

            seed: (Optional) Seed to the random generator, if not specified we will auto
                generate one.
        """

        schema = get_schema("Multinomial", 7, "")
        op = Op(self, "Multinomial", schema)
        return op(
            *self._prepare_inputs(schema, input),
            dtype=dtype,
            sample_size=sample_size,
            seed=seed,
        )

    T_Or: TypeAlias = BOOL

    T1_Or: TypeAlias = BOOL

    def Or(self, A: T_Or, B: T_Or) -> T1_Or:
        r"""[🌐 Or(7)](https://onnx.ai/onnx/operators/onnx__Or.html#or-7 "Online Documentation")


        Returns the tensor resulted from performing the `or` logical operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: (non-differentiable) First input operand for the logical operator.

            B: (non-differentiable) Second input operand for the logical operator.
        """

        schema = get_schema("Or", 7, "")
        op = Op(self, "Or", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_PRelu = TypeVar("T_PRelu", DOUBLE, FLOAT, FLOAT16)

    def PRelu(self, X: T_PRelu, slope: T_PRelu) -> T_PRelu:
        r"""[🌐 PRelu(7)](https://onnx.ai/onnx/operators/onnx__PRelu.html#prelu-7 "Online Documentation")


        PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
        output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
        `f(x) = x for x >= 0`., is applied to the data tensor elementwise.
        This operator supports **unidirectional broadcasting** (tensor slope should be unidirectional broadcastable to input tensor X); for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.

        Args:
            X: Input tensor

            slope: Slope tensor. The shape of slope can be smaller than first input X;
                if so, its shape must be unidirectional broadcastable to X
        """

        schema = get_schema("PRelu", 7, "")
        op = Op(self, "PRelu", schema)
        return op(*self._prepare_inputs(schema, X, slope))

    T_Pow = TypeVar("T_Pow", DOUBLE, FLOAT, FLOAT16)

    def Pow(self, X: T_Pow, Y: T_Pow) -> T_Pow:
        r"""[🌐 Pow(7)](https://onnx.ai/onnx/operators/onnx__Pow.html#pow-7 "Online Documentation")


        Pow takes input data (Tensor<T>) and exponent Tensor, and
        produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
        is applied to the data tensor elementwise.
        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.

        Args:
            X: First operand, base of the exponent.

            Y: Second operand, power of the exponent.
        """

        schema = get_schema("Pow", 7, "")
        op = Op(self, "Pow", schema)
        return op(*self._prepare_inputs(schema, X, Y))

    T_RNN = TypeVar("T_RNN", DOUBLE, FLOAT, FLOAT16)

    T1_RNN: TypeAlias = INT32

    def RNN(
        self,
        X: T_RNN,
        W: T_RNN,
        R: T_RNN,
        B: Optional[T_RNN] = None,
        sequence_lens: Optional[T1_RNN] = None,
        initial_h: Optional[T_RNN] = None,
        *,
        activation_alpha: Optional[Sequence[float]] = None,
        activation_beta: Optional[Sequence[float]] = None,
        activations: Sequence[str] = ("Tanh", "Tanh"),
        clip: Optional[float] = None,
        direction: str = "forward",
        hidden_size: Optional[int] = None,
    ) -> Tuple[T_RNN, T_RNN]:
        r"""[🌐 RNN(7)](https://onnx.ai/onnx/operators/onnx__RNN.html#rnn-7 "Online Documentation")


        Computes an one-layer simple RNN. This operator is usually supported
        via some custom implementation such as CuDNN.

        Notations:

        `X` - input tensor

        `i` - input gate

        `t` - time step (t-1 means previous time step)

        `Wi` - W parameter weight matrix for input gate

        `Ri` - R recurrence weight matrix for input gate

        `Wbi` - W parameter bias vector for input gate

        `Rbi` - R parameter bias vector for input gate

        `WBi` - W parameter weight matrix for backward input gate

        `RBi` - R recurrence weight matrix for backward input gate

        `WBbi` - WR bias vectors for backward input gate

        `RBbi` - RR bias vectors for backward input gate

        `H` - Hidden state

        `num_directions` - 2 if direction == bidirectional else 1

        Activation functions:

          Relu(x)                - max(0, x)

          Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

          Sigmoid(x)             - 1/(1 + e^{-x})

          (NOTE: Below are optional)

          Affine(x)              - alpha*x + beta

          LeakyRelu(x)           - x if x >= 0 else alpha * x

          ThresholdedRelu(x)     - x if x >= alpha else 0

          ScaledTanh(x)          - alpha*Tanh(beta*x)

          HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

          Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

          Softsign(x)            - x/(1 + |x|)

          Softplus(x)            - log(1 + e^x)

        Equations (Default: f=Tanh):

          - Ht = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Wbi + Rbi)
        This operator has **optional** inputs/outputs. See `ONNX <https://github.com/onnx/onnx/blob/master/docs/IR.md>`_ for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.


        Args:
            X: The input sequences packed (and potentially padded) into one 3-D tensor
                with the shape of `[seq_length, batch_size, input_size]`.

            W: The weight tensor for input gate. Concatenation of `Wi` and `WBi` (if
                bidirectional). The tensor has shape `[num_directions, hidden_size,
                input_size]`.

            R: The recurrence weight tensor. Concatenation of `Ri` and `RBi` (if
                bidirectional). The tensor has shape `[num_directions, hidden_size,
                hidden_size]`.

            B: (optional) The bias tensor for input gate. Concatenation of `[Wbi, Rbi]`
                and `[WBbi, RBbi]` (if bidirectional). The tensor has shape
                `[num_directions, 2*hidden_size]`. Optional: If not specified - assumed
                to be 0.

            sequence_lens: (optional) Optional tensor specifying lengths of the
                sequences in a batch. If not specified - assumed all sequences in the
                batch to have length `seq_length`. It has shape `[batch_size]`.

            initial_h: (optional) Optional initial value of the hidden. If not specified
                - assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            activation_alpha: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.For example with LeakyRelu, the default
                alpha is 0.01.

            activation_beta: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.

            activations: One (or two if bidirectional) activation function for input
                gate. The activation function must be one of the activation functions
                specified above. Optional: Default `Tanh` if not specified.

            clip: Cell clip threshold. Clipping bounds the elements of a tensor in the
                range of [-threshold, +threshold] and is applied to the input of
                activations. No clip if not specified.

            direction: Specify if the RNN is forward, reverse, or bidirectional. Must be
                one of forward (default), reverse, or bidirectional.

            hidden_size: Number of neurons in the hidden layer
        """

        schema = get_schema("RNN", 7, "")
        op = Op(self, "RNN", schema)
        return op(
            *self._prepare_inputs(schema, X, W, R, B, sequence_lens, initial_h),
            activation_alpha=activation_alpha,
            activation_beta=activation_beta,
            activations=activations,
            clip=clip,
            direction=direction,
            hidden_size=hidden_size,
        )

    T_Sin = TypeVar("T_Sin", DOUBLE, FLOAT, FLOAT16)

    def Sin(self, input: T_Sin) -> T_Sin:
        r"""[🌐 Sin(7)](https://onnx.ai/onnx/operators/onnx__Sin.html#sin-7 "Online Documentation")


        Calculates the sine of the given input tensor, element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Sin", 7, "")
        op = Op(self, "Sin", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Sub = TypeVar("T_Sub", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def Sub(self, A: T_Sub, B: T_Sub) -> T_Sub:
        r"""[🌐 Sub(7)](https://onnx.ai/onnx/operators/onnx__Sub.html#sub-7 "Online Documentation")


        Performs element-wise binary subtraction (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: First operand.

            B: Second operand.
        """

        schema = get_schema("Sub", 7, "")
        op = Op(self, "Sub", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_Tan = TypeVar("T_Tan", DOUBLE, FLOAT, FLOAT16)

    def Tan(self, input: T_Tan) -> T_Tan:
        r"""[🌐 Tan(7)](https://onnx.ai/onnx/operators/onnx__Tan.html#tan-7 "Online Documentation")


        Calculates the tangent of the given input tensor, element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Tan", 7, "")
        op = Op(self, "Tan", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Upsample = TypeVar(
        "T_Upsample",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Upsample(
        self, X: T_Upsample, *, mode: str = "nearest", scales: Sequence[float]
    ) -> T_Upsample:
        r"""[🌐 Upsample(7)](https://onnx.ai/onnx/operators/onnx__Upsample.html#upsample-7 "Online Documentation")


        Upsample the input tensor.
        Each dimension value of the output tensor is:
          output_dimension = floor(input_dimension * scale).


        Args:
            X: N-D tensor

            mode: Two interpolation modes: nearest (default), and linear (including
                bilinear, trilinear, etc)

            scales: The scale array along each dimension. It takes value greater than or
                equal to 1. The number of elements of 'scales' should be the same as the
                rank of input 'X'.
        """

        schema = get_schema("Upsample", 7, "")
        op = Op(self, "Upsample", schema)
        return op(*self._prepare_inputs(schema, X), mode=mode, scales=scales)

    T_Xor: TypeAlias = BOOL

    T1_Xor: TypeAlias = BOOL

    def Xor(self, A: T_Xor, B: T_Xor) -> T1_Xor:
        r"""[🌐 Xor(7)](https://onnx.ai/onnx/operators/onnx__Xor.html#xor-7 "Online Documentation")


        Returns the tensor resulted from performing the `xor` logical operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: (non-differentiable) First input operand for the logical operator.

            B: (non-differentiable) Second input operand for the logical operator.
        """

        schema = get_schema("Xor", 7, "")
        op = Op(self, "Xor", schema)
        return op(*self._prepare_inputs(schema, A, B))
