\name{DemonsRegistrationFilter}
\alias{DemonsRegistrationFilter}
\title{DemonsRegistrationFilter}
\Rdversion{1.1}
\docType{class}
\description{
Deformably register two images using the demons algorithm.
DemonsRegistrationFilter}
\details{
DemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the displacement field which will map a moving image onto
a fixed image.
A displacement field is represented as a image whose pixel type is
some vector type with at least N elements, where N is the dimension of
the fixed image. The vector type must support element access via
operator []. It is assumed that the vector elements behave like
floating point scalars.
This class is templated over the fixed image type, moving image type
and the displacement field type.
The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial displacement field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.
The algorithm has one parameters: the number of iteration to be
performed.
The output displacement field can be obtained via methods GetOutput or
GetDisplacementField.
This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .
WARNING:
This filter assumes that the fixed image type, moving image type and
displacement field type all have the same number of dimensions.
See:
DemonsRegistrationFunction
itk::DemonsRegistrationFilter for the Doxygen on the original ITK class.
DemonsRegistrationFilter}
%C++ includes: sitkDemonsRegistrationFilter.h
\section{Methods}{
\describe{
\item{ DemonsRegistrationFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &fixedImage, const Image &movingImage):}{}
\item{Image Execute(const Image &fixedImage, const Image &movingImage, const Image &initialDisplacementField):}{
Execute the filter on the input image
}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetIntensityDifferenceThreshold() const:}{}
\item{double GetMaximumError() const:}{
Set/Get the desired maximum error of the Guassian kernel approximate.
}
\item{unsigned int GetMaximumKernelWidth() const:}{
Set/Get the desired limits of the Gaussian kernel width.
}
\item{double GetMaximumRMSError() const:}{}
\item{double GetMetric() const:}{
Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the the overlapping region between the two images. This
is value is only available for the previous iteration and NOT the
current iteration.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetSmoothDisplacementField() const:}{
Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()
}
\item{bool GetSmoothUpdateField() const:}{
Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()
}
\item{std::vector< double > GetStandardDeviations() const:}{
Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.
}
\item{std::vector< double > GetUpdateFieldStandardDeviations() const:}{
Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.
}
\item{bool GetUseImageSpacing() const:}{}
\item{bool GetUseMovingImageGradient() const:}{
Switch between using the fixed image and moving image gradient for
computing the displacement field updates.
}
\item{Self SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold):}{
Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.
}
\item{Self SetMaximumError(double MaximumError):}{
Set/Get the desired maximum error of the Guassian kernel approximate.
}
\item{Self SetMaximumKernelWidth(unsigned int MaximumKernelWidth):}{
Set/Get the desired limits of the Gaussian kernel width.
}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetSmoothDisplacementField(bool SmoothDisplacementField):}{
Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()
}
\item{Self SetSmoothUpdateField(bool SmoothUpdateField):}{
Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()
}
\item{Self SetStandardDeviations(double value):}{
Set the values of the StandardDeviations vector all to value
}
\item{Self SetStandardDeviations(std::vector< double > StandardDeviations):}{
Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.
}
\item{Self SetUpdateFieldStandardDeviations(double value):}{
Set the values of the UpdateFieldStandardDeviations vector all to
value
}
\item{Self SetUpdateFieldStandardDeviations(std::vector< double > UpdateFieldStandardDeviations):}{
Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{}
\item{Self SetUseMovingImageGradient(bool UseMovingImageGradient):}{
Switch between using the fixed image and moving image gradient for
computing the displacement field updates.
}
\item{Self SmoothDisplacementFieldOff():}{}
\item{Self SmoothDisplacementFieldOn():}{
Set the value of SmoothDisplacementField to true or false
respectfully.
}
\item{Self SmoothUpdateFieldOff():}{}
\item{Self SmoothUpdateFieldOn():}{
Set the value of SmoothUpdateField to true or false respectfully.
}
\item{void StopRegistration():}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{Self UseMovingImageGradientOff():}{}
\item{Self UseMovingImageGradientOn():}{
Set the value of UseMovingImageGradient to true or false respectfully.
}
\item{ ~DemonsRegistrationFilter():}{
Destructor
}
}
}
