---
title: Survey Tool Accounts
---

# Survey Tool Accounts

[**Survey Tool**](https://st.unicode.org) **\|** [**Guide**](/translation/getting-started/guide) **\|** [**FAQ and Known Bugs**](/index/survey-tool/faq-and-known-bugs)

Anyone is welcome to try out the [**Survey Tool**](https://st.unicode.org), although only those with accounts will be able to make changes. To get an account, or if you have forgotten your login ID or password, please contact your CLDR TC representative. If you don't belong to a Unicode member organization, and are a native speaker of a language other than American English, you can obtain a guest account.

To determine whether you need an account for what you want to do, see [When Do You Need a Survey Tool Account?](/requesting_changes#when-to-fix-in-survey-tool) If you only wish to report a bug, you may be able to simply [file a ticket](/requesting_changes#how-to-file-a-ticket).

There are three types of accounts:

- Representatives belonging to Unicode member organizations in the CLDR technical committee will receive instructions from their CLDR contacts.
- Representatives from other [Unicode member organizations](https://unicode.org/consortium/memblogo.html) (including [liaison members](https://unicode.org/consortium/memblogo.html#liais)) also get more weight in resolving conflicts. So if you are associated with a Unicode member organization, be sure to have that member's Unicode contact submit your name directly for an account.
- If there is an official organization for your language that would like to have liaison status for contributing data, please file a separate ticket under [CLDR Change Requests](/index/bug-reports).
- Other individuals can request accounts via the [Unicode contact form](https://www.unicode.org/reporting.html). In resolving conflicts, they are treated as if they all belong to a single organization ("Guest").

When you request an account, you must list all of the locale(s)/language(s) that you would like to provide data for, using the appropriate locale codes; see [Picking the Right Language Identifier](/index/cldr-spec/picking-the-right-language-code). If the locale is not present in CLDR, you can request that it be added, and you will be expected to provide certain core data to begin the process. Please see [Adding New Locales](/requesting_changes#adding-new-locales) under [CLDR Change Requests](/requesting_changes).

## Logging in

Once you have an account, open the [Unicode CLDR Survey Tool](https://st.unicode.org), click the 'Login' button and fill in your email address and password.
