/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.List;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DecorateEntityImage;

public final class ClusterHeader {
    private int titleAndAttributeWidth = 0;
    private int titleAndAttributeHeight = 0;
    private final TextBlock title;
    private final TextBlock stereo;
    private final Entity g;

    public ClusterHeader(Entity g2, PortionShower portionShower, StringBounder stringBounder) {
        ISkinParam skinParam = g2.getSkinParam();
        this.g = g2;
        this.title = this.getTitleBlock();
        this.stereo = this.getStereoBlock(portionShower);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(this.stereo, this.title, this.getTitleHorizontalAlignment());
        XDimension2D dimLabel = stereoAndTitle.calculateDimension(stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            XDimension2D dimAttribute = g2.getStateHeader(skinParam).calculateDimension(stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g2.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            this.titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            this.titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public final TextBlock getTitle() {
        return this.title;
    }

    public final TextBlock getStereo() {
        return this.stereo;
    }

    private TextBlock getTitleBlock() {
        Display label = this.g.getDisplay();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Style style = this.getStyle();
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.g.getSkinParam().getIHtmlColorSet(), this.g.getColors());
        HorizontalAlignment alignment = style.getHorizontalAlignment();
        return label.create(fontConfiguration, alignment, this.g.getSkinParam());
    }

    public Style getStyle() {
        StyleSignatureBasic signature = this.getSignature();
        return signature.withTOBECHANGED(this.g.getStereotype()).with(this.g.getStereostyles()).getMergedStyle(this.g.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getSignature() {
        SName sname = this.g.getSkinParam().getUmlDiagramType().getStyleName();
        USymbol uSymbol = this.g.getUSymbol();
        StyleSignatureBasic signature = this.g.getGroupType() == GroupType.STATE ? StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.composite, SName.title) : (uSymbol != null ? StyleSignatureBasic.of(SName.root, SName.element, sname, uSymbol.getSName(), SName.composite, SName.title) : (this.g.getGroupType() == GroupType.PACKAGE ? StyleSignatureBasic.of(SName.root, SName.element, sname, SName.package_, SName.title) : StyleSignatureBasic.of(SName.root, SName.element, sname, SName.composite, SName.title)));
        return signature;
    }

    public HorizontalAlignment getTitleHorizontalAlignment() {
        return this.getStyle().getHorizontalAlignment();
    }

    private TextBlock getStereoBlock(PortionShower portionShower) {
        TextBlock stereo = this.getStereoBlockWithoutLegend(portionShower);
        DisplayPositioned legend = this.g.getLegend();
        if (legend == null || legend.isNull()) {
            return stereo;
        }
        TextBlock legendBlock = EntityImageLegend.create(legend.getDisplay(), this.g.getSkinParam());
        return DecorateEntityImage.add(legendBlock, stereo, legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    private TextBlock getStereoBlockWithoutLegend(PortionShower portionShower) {
        Stereotype stereotype = this.g.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam skinParam = this.g.getSkinParam();
        TextBlock tmp = stereotype.getSprite(skinParam);
        if (tmp != null) {
            return tmp;
        }
        List<String> stereos = stereotype.getLabels(skinParam.guillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        List<String> visibleStereotypes = portionShower.getVisibleStereotypeLabels(this.g);
        if (visibleStereotypes == null || visibleStereotypes.isEmpty()) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Style style = Cluster.getDefaultStyleDefinition(skinParam.getUmlDiagramType().getStyleName(), this.g.getUSymbol(), this.g.getGroupType()).forStereotypeItself(this.g.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        HorizontalAlignment horizontalAlignment = this.getTitleHorizontalAlignment();
        return Display.create(visibleStereotypes).create(fontConfiguration, horizontalAlignment, skinParam);
    }
}

