﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/scheduler/Scheduler_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Scheduler {
namespace Model {
class CreateScheduleResult {
 public:
  AWS_SCHEDULER_API CreateScheduleResult() = default;
  AWS_SCHEDULER_API CreateScheduleResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SCHEDULER_API CreateScheduleResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the schedule.</p>
   */
  inline const Aws::String& GetScheduleArn() const { return m_scheduleArn; }
  template <typename ScheduleArnT = Aws::String>
  void SetScheduleArn(ScheduleArnT&& value) {
    m_scheduleArnHasBeenSet = true;
    m_scheduleArn = std::forward<ScheduleArnT>(value);
  }
  template <typename ScheduleArnT = Aws::String>
  CreateScheduleResult& WithScheduleArn(ScheduleArnT&& value) {
    SetScheduleArn(std::forward<ScheduleArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateScheduleResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scheduleArn;

  Aws::String m_requestId;
  bool m_scheduleArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Scheduler
}  // namespace Aws
