/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class DataSourceConfigurationStorageDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataSourceConfigurationStorageDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceStorage";
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private DBPImage icon;
    private DBPDataSourceConfigurationStorage instance;

    public DataSourceConfigurationStorageDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = DBIcon.DATABASE_DEFAULT;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public DBPDataSourceConfigurationStorage getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (DBPDataSourceConfigurationStorage)this.implType.createInstance(DBPDataSourceConfigurationStorage.class);
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source configuration storage '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }
}

