/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLDialects
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.dialects";
    private IAdaptable element;
    private SQLDialectMetadata curDialect;
    private Text reservedWordsText;
    private Text dataTypesText;
    private Text functionNamesText;
    private Text transactionKeywordsText;
    private Text ddlKeywordsText;
    private Text dmlKeywordsText;
    private Text executeKeywordsText;
    private Text blockStatementsText;
    private Text statementDelimiterText;
    private Text dualTableNameText;
    private Text testQueryText;
    private Text dialectText;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        boolean isPrefPage = this.element == null;
        Composite composite = UIUtils.createComposite((Composite)parent, (int)(isPrefPage ? 2 : 1));
        if (isPrefPage) {
            Composite dialectsGroup = UIUtils.createComposite((Composite)composite, (int)1);
            dialectsGroup.setLayoutData((Object)new GridData(1072));
            UIUtils.createControlLabel((Composite)dialectsGroup, (String)"Dialects", (int)2);
            final Tree dialectTable = new Tree(dialectsGroup, 2564);
            GridData gd = new GridData(1808);
            gd.heightHint = 200;
            dialectTable.setLayoutData((Object)gd);
            List dialects = DBWorkbench.getPlatform().getSQLDialectRegistry().getRootDialects();
            for (SQLDialectMetadata dialect : dialects) {
                this.createDialectItem(dialectTable, null, dialect);
            }
            dialectTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeItem[] selection = dialectTable.getSelection();
                    if (selection.length == 1) {
                        PrefPageSQLDialects.this.curDialect = (SQLDialectDescriptor)selection[0].getData();
                        PrefPageSQLDialects.this.loadDialectSettings();
                    }
                }
            });
        }
        Composite settingsGroup = UIUtils.createComposite((Composite)composite, (int)2);
        GridData gd = new GridData(770);
        gd.widthHint = UIUtils.getFontHeight((Control)settingsGroup) * 50;
        settingsGroup.setLayoutData((Object)gd);
        if (!isPrefPage) {
            Composite nameComp = UIUtils.createComposite((Composite)settingsGroup, (int)2);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            nameComp.setLayoutData((Object)gd);
            this.dialectText = UIUtils.createLabelText((Composite)nameComp, (String)"Dialect", (String)"", (int)8);
        }
        Group kwGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)"Keywords", (int)2, (int)768, (int)0);
        ((GridData)kwGroup.getLayoutData()).horizontalSpan = 2;
        this.reservedWordsText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Reserved words", (String)"", (int)2048);
        this.dataTypesText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Data Types", (String)"", (int)2048);
        this.functionNamesText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Function names", (String)"", (int)2048);
        this.ddlKeywordsText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"DDL keywords", (String)"", (int)2048);
        this.dmlKeywordsText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Data modify keywords", (String)"", (int)2048);
        this.executeKeywordsText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Execute keywords", (String)"", (int)2048);
        this.transactionKeywordsText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Transaction keywords", (String)"", (int)2048);
        this.blockStatementsText = UIUtils.createLabelTextAdvanced((Composite)kwGroup, (String)"Block statements", (String)"", (int)2048);
        Group miscGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)"Miscellaneous", (int)2, (int)768, (int)0);
        this.statementDelimiterText = UIUtils.createLabelText((Composite)miscGroup, (String)"Statement delimiter", (String)"", (int)2048);
        this.dualTableNameText = UIUtils.createLabelText((Composite)miscGroup, (String)"Dual table name", (String)"", (int)2048);
        this.testQueryText = UIUtils.createLabelText((Composite)miscGroup, (String)"Test query", (String)"", (int)2048);
        this.performDefaults();
        return composite;
    }

    private void createDialectItem(Tree dialectTable, TreeItem parentItem, SQLDialectMetadata dialect) {
        TreeItem di;
        if (!dialect.isHidden()) {
            di = parentItem == null ? new TreeItem(dialectTable, 0) : new TreeItem(parentItem, 0);
            di.setText(dialect.getLabel());
            di.setImage(DBeaverIcons.getImage((DBPImage)dialect.getIcon()));
            di.setData((Object)dialect);
        } else {
            di = parentItem;
        }
        List subDialects = dialect.getSubDialects(true);
        subDialects.sort(Comparator.comparing(SQLDialectMetadata::getLabel));
        for (SQLDialectMetadata dm : subDialects) {
            this.createDialectItem(dialectTable, di, dm);
        }
        if (di != null) {
            di.setExpanded(true);
        }
    }

    protected void performDefaults() {
        DBPDataSourceContainer dataSource;
        if (this.element != null && (dataSource = (DBPDataSourceContainer)this.element.getAdapter(DBPDataSourceContainer.class)) != null) {
            this.curDialect = dataSource.getScriptDialect();
        }
        this.loadDialectSettings();
        super.performDefaults();
    }

    private void loadDialectSettings() {
        if (this.curDialect == null) {
            return;
        }
        if (this.dialectText != null) {
            this.dialectText.setText(this.curDialect.getLabel());
        }
        this.reservedWordsText.setText(String.join((CharSequence)",", this.curDialect.getReservedWords()));
        this.dataTypesText.setText(String.join((CharSequence)",", this.curDialect.getDataTypes()));
        this.functionNamesText.setText(String.join((CharSequence)",", this.curDialect.getFunctions()));
        this.ddlKeywordsText.setText(String.join((CharSequence)",", this.curDialect.getDDLKeywords()));
        this.dmlKeywordsText.setText(String.join((CharSequence)",", this.curDialect.getDMLKeywords()));
        this.executeKeywordsText.setText(String.join((CharSequence)",", this.curDialect.getExecuteKeywords()));
        this.transactionKeywordsText.setText(String.join((CharSequence)",", this.curDialect.getTransactionKeywords()));
        this.statementDelimiterText.setText(this.curDialect.getScriptDelimiter());
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

