/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.core.ui.components.FocusRequestor;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;

class BookmarkPopupMenu
extends JPopupMenu {
    private static final int RENAME_TEXTFIELD_WIDTH = 40;
    private final BookmarksController bookmarksController;

    BookmarkPopupMenu(NodeBookmark bookmark, BookmarksController bookmarksController) {
        this.bookmarksController = bookmarksController;
        this.buildMenu(bookmark);
    }

    private void buildMenu(NodeBookmark bookmark) {
        this.addGotoNodeMenuItem(bookmark);
        this.addOpenAsRootDirectMenuItem(bookmark);
        this.addOpenAsNewViewRootMenuItem(bookmark);
        this.addSeparator();
        this.addRemoveMenuItem(bookmark);
        this.addRenameMenuItem(bookmark);
        this.addOpenAsRootToggleMenuItem(bookmark);
        MnemonicSetter.INSTANCE.setComponentMnemonics(new Container[]{this});
    }

    private void addGotoNodeMenuItem(NodeBookmark bookmark) {
        JMenuItem selectItem = TranslatedElementFactory.createMenuItem((String)"bookmark.goto_node");
        selectItem.addActionListener(e -> bookmark.open(false));
        this.add(selectItem);
    }

    private void addOpenAsRootDirectMenuItem(NodeBookmark bookmark) {
        JMenuItem openAsRootDirectItem = TranslatedElementFactory.createMenuItem((String)"bookmark.open_as_root");
        openAsRootDirectItem.addActionListener(e -> bookmark.open(true));
        this.add(openAsRootDirectItem);
    }

    private void addOpenAsNewViewRootMenuItem(NodeBookmark bookmark) {
        JMenuItem openAsRootDirectItem = TranslatedElementFactory.createMenuItem((String)"bookmark.open_as_new_view_root");
        openAsRootDirectItem.addActionListener(e -> bookmark.openAsNewView());
        this.add(openAsRootDirectItem);
    }

    private void addRemoveMenuItem(NodeBookmark bookmark) {
        JMenuItem removeItem = TranslatedElementFactory.createMenuItem((String)"bookmark.delete");
        removeItem.addActionListener(e -> this.bookmarksController.removeBookmark(bookmark.getNode()));
        this.add(removeItem);
    }

    private void addRenameMenuItem(NodeBookmark bookmark) {
        JMenuItem renameItem = TranslatedElementFactory.createMenuItem((String)"bookmark.rename");
        renameItem.addActionListener(e -> this.showRenameDialog(bookmark));
        this.add(renameItem);
    }

    private void addOpenAsRootToggleMenuItem(NodeBookmark bookmark) {
        JCheckBoxMenuItem openAsRootItem = TranslatedElementFactory.createCheckboxMenuItem((String)"bookmark.opens_as_root");
        openAsRootItem.setSelected(bookmark.getDescriptor().opensAsRoot());
        openAsRootItem.addActionListener(e -> this.toggleOpenAsRoot(bookmark));
        if (bookmark.getNode().isRoot()) {
            openAsRootItem.setEnabled(false);
        }
        this.add(openAsRootItem);
    }

    private void showRenameDialog(NodeBookmark bookmark) {
        String bookmarkName;
        String currentName = bookmark.getDescriptor().getName();
        boolean currentOpensAsRoot = bookmark.getDescriptor().opensAsRoot();
        String title = TextUtils.getText((String)"bookmark.rename");
        JTextField nameInput = new JTextField(currentName, 40);
        FocusRequestor.requestFocus((Component)nameInput);
        if (0 == JOptionPane.showConfirmDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), nameInput, title, 2, -1) && !(bookmarkName = nameInput.getText().trim()).isEmpty()) {
            NodeBookmarkDescriptor descriptor = new NodeBookmarkDescriptor(bookmarkName, currentOpensAsRoot);
            this.bookmarksController.addBookmark(bookmark.getNode(), descriptor);
        }
    }

    private void toggleOpenAsRoot(NodeBookmark bookmark) {
        boolean newOpensAsRoot = !bookmark.getDescriptor().opensAsRoot();
        NodeBookmarkDescriptor newDescriptor = new NodeBookmarkDescriptor(bookmark.getDescriptor().getName(), newOpensAsRoot);
        this.bookmarksController.addBookmark(bookmark.getNode(), newDescriptor);
    }
}

