# ALCO, chapter 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("alco01.tst");

# doc/ALCO.xml:25-39
gap> O := OctavianIntegers;
OctavianIntegers
gap> g := List(Basis(O), x -> List(Basis(O), y -> 
> Norm(x+y) - Norm(x) - Norm(y)));;
gap> Display(g);
[ [   2,   0,  -1,   0,   0,   0,   0,   0 ],
  [   0,   2,   0,  -1,   0,   0,   0,   0 ],
  [  -1,   0,   2,  -1,   0,   0,   0,   0 ],
  [   0,  -1,  -1,   2,  -1,   0,   0,   0 ],
  [   0,   0,   0,  -1,   2,  -1,   0,   0 ],
  [   0,   0,   0,   0,  -1,   2,  -1,   0 ],
  [   0,   0,   0,   0,   0,  -1,   2,  -1 ],
  [   0,   0,   0,   0,   0,   0,  -1,   2 ] ]
gap> IsGossetLatticeGramMatrix(g);
true

# doc/ALCO.xml:46-56
gap> short := Set(ShortestVectors(g,4).vectors, y -> 
> LinearCombination(Basis(OctavianIntegers), y));;
gap> s := First(short, x -> x^2 + x + 2*One(x) = Zero(x));
(-1)*e1+(-1/2)*e2+(-1/2)*e3+(-1/2)*e4+(-1/2)*e8
gap> gens := List(Basis(OctavianIntegers), x -> 
> x*[[s,s,0],[0,s,s],ComplexConjugate([s,s,s])]);;
gap> gens := Concatenation(gens);; 
gap> L := OctonionLatticeByGenerators(gens, One(O)*IdentityMat(3)/2);
<free left module over Integers, with 24 generators>
gap> IsLeechLatticeGramMatrix(GramMatrix(L));
true

# doc/ALCO.xml:56-79
gap> J := AlbertAlgebra(Rationals);
<algebra-with-one of dimension 27 over Rationals>
gap> SemiSimpleType(Derivations(Basis(J)));
"F4"
gap> i := Basis(J){[1..8]};
[ i1, i2, i3, i4, i5, i6, i7, i8 ]
gap> j := Basis(J){[9..16]};
[ j1, j2, j3, j4, j5, j6, j7, j8 ]
gap> k := Basis(J){[17..24]};
[ k1, k2, k3, k4, k5, k6, k7, k8 ]
gap> e := Basis(J){[25..27]};
[ ei, ej, ek ]
gap> ForAll(e, IsIdempotent);
true
gap> Set(i, x -> x^2);
[ ej+ek ]
gap> Set(j, x -> x^2);
[ ei+ek ]
gap> One(J);
ei+ej+ek
gap> Determinant(One(J));
1
gap> Trace(One(J));
3

#
gap> STOP_TEST("alco01.tst", 1);
