/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.spiffe;

import java.util.Map;
import org.keycloak.Config;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.provider.ClientAssertionIdentityProviderFactory;
import org.keycloak.broker.spiffe.SpiffeClientAssertionStrategy;
import org.keycloak.broker.spiffe.SpiffeIdentityProvider;
import org.keycloak.broker.spiffe.SpiffeIdentityProviderConfig;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class SpiffeIdentityProviderFactory
extends AbstractIdentityProviderFactory<SpiffeIdentityProvider>
implements EnvironmentDependentProviderFactory,
ClientAssertionIdentityProviderFactory {
    public static final String PROVIDER_ID = "spiffe";

    public String getName() {
        return "SPIFFE";
    }

    public SpiffeIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new SpiffeIdentityProvider(session, new SpiffeIdentityProviderConfig(model));
    }

    public Map<String, String> parseConfig(KeycloakSession session, String configString) {
        throw new UnsupportedOperationException();
    }

    public IdentityProviderModel createConfig() {
        return new SpiffeIdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SPIFFE);
    }

    public ClientAssertionIdentityProviderFactory.ClientAssertionStrategy getClientAssertionStrategy() {
        return new SpiffeClientAssertionStrategy();
    }
}

