/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.desc;

import io.quarkus.gizmo2.SimpleTyped;
import io.quarkus.gizmo2.desc.MemberDesc;
import io.quarkus.gizmo2.impl.FieldDescImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Field;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldDesc
extends MemberDesc,
SimpleTyped {
    public static FieldDesc of(ClassDesc owner, String name, ClassDesc type) {
        Assert.checkNotNullParam((String)"owner", (Object)owner);
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"type", (Object)type);
        return new FieldDescImpl(owner, name, type);
    }

    public static FieldDesc of(ClassDesc owner, String name, Class<?> type) {
        Assert.checkNotNullParam((String)"type", type);
        return FieldDesc.of(owner, name, Util.classDesc(type));
    }

    public static FieldDesc of(Class<?> owner, String name) {
        Assert.checkNotNullParam((String)"owner", owner);
        Assert.checkNotNullParam((String)"name", (Object)name);
        try {
            return FieldDesc.of(owner.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No such field \"" + name + "\" found on " + String.valueOf(owner));
        }
    }

    public static FieldDesc of(Field field) {
        return FieldDesc.of(Util.classDesc(field.getDeclaringClass()), field.getName(), Util.classDesc(field.getType()));
    }

    @Override
    public ClassDesc type();
}

