/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractGeneratedEcKeyProviderFactory;
import org.keycloak.keys.GeneratedEcdhKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedEcdhKeyProviderFactory
extends AbstractGeneratedEcKeyProviderFactory<KeyProvider> {
    public static final String DEFAULT_ECDH_ELLIPTIC_CURVE = "P-256";
    public static final String ECDH_ALGORITHM_KEY = "ecdhAlgorithm";
    public static final String ECDH_ELLIPTIC_CURVE_KEY = "ecdhEllipticCurveKey";
    public static final String ECDH_PRIVATE_KEY_KEY = "ecdhPrivateKey";
    public static final String ECDH_PUBLIC_KEY_KEY = "ecdhPublicKey";
    protected static ProviderConfigProperty ECDH_ELLIPTIC_CURVE_PROPERTY = new ProviderConfigProperty("ecdhEllipticCurveKey", "Elliptic Curve", "Elliptic Curve used in ECDH", "List", (Object)String.valueOf("P-256"), new String[]{"P-256", "P-384", "P-521"});
    protected static ProviderConfigProperty ECDH_ALGORITHM_PROPERTY = new ProviderConfigProperty("ecdhAlgorithm", "Algorithm", "Algorithm for processing the Content Encryption Key", "List", (Object)"ECDH-ES", new String[]{"ECDH-ES", "ECDH-ES+A128KW", "ECDH-ES+A192KW", "ECDH-ES+A256KW"});
    private static final String HELP_TEXT = "Generates ECDH keys";
    public static final String ID = "ecdh-generated";
    private static final Logger logger = Logger.getLogger(GeneratedEcdhKeyProviderFactory.class);
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractGeneratedEcKeyProviderFactory.configurationBuilder().property(ECDH_ELLIPTIC_CURVE_PROPERTY).property(ECDH_ALGORITHM_PROPERTY).build();

    public static String convertECDomainParmNistRepToJWEAlgorithm(String ecInNistRep) {
        switch (ecInNistRep) {
            case "P-256": {
                return "ECDH-ES+A128KW";
            }
            case "P-384": {
                return "ECDH-ES+A192KW";
            }
            case "P-521": {
                return "ECDH-ES+A256KW";
            }
        }
        return null;
    }

    public static String convertJWEAlgorithmToECDomainParmNistRep(String algorithm) {
        switch (algorithm) {
            case "ECDH-ES+A128KW": {
                return DEFAULT_ECDH_ELLIPTIC_CURVE;
            }
            case "ECDH-ES+A192KW": {
                return "P-384";
            }
            case "ECDH-ES+A256KW": {
                return "P-521";
            }
        }
        return null;
    }

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedEcdhKeyProvider(session.getContext().getRealm(), model);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    protected String getDefaultEcEllipticCurve() {
        return DEFAULT_ECDH_ELLIPTIC_CURVE;
    }

    @Override
    protected String getEcEllipticCurveKey() {
        return ECDH_ELLIPTIC_CURVE_KEY;
    }

    @Override
    protected String getEcEllipticCurveKey(String algorithm) {
        if ("ECDH-ES".equals(algorithm)) {
            return DEFAULT_ECDH_ELLIPTIC_CURVE;
        }
        return GeneratedEcdhKeyProviderFactory.convertJWEAlgorithmToECDomainParmNistRep(algorithm);
    }

    @Override
    protected ProviderConfigProperty getEcEllipticCurveProperty() {
        return ECDH_ELLIPTIC_CURVE_PROPERTY;
    }

    @Override
    protected String getEcPrivateKeyKey() {
        return ECDH_PRIVATE_KEY_KEY;
    }

    @Override
    protected String getEcPublicKeyKey() {
        return ECDH_PUBLIC_KEY_KEY;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected boolean isSupportedEcAlgorithm(String algorithm) {
        return algorithm.equals("ECDH-ES") || algorithm.equals("ECDH-ES+A128KW") || algorithm.equals("ECDH-ES+A192KW") || algorithm.equals("ECDH-ES+A256KW");
    }

    @Override
    protected boolean isValidKeyUse(KeyUse keyUse) {
        return KeyUse.ENC.equals((Object)keyUse);
    }
}

