/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.xml.XmlTableFunction;
import org.hibernate.dialect.function.xml.XmlTableSetReturningFunctionTypeResolver;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableValueColumnDefinition;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class SybaseASEXmlTableFunction
extends XmlTableFunction {
    public SybaseASEXmlTableFunction(TypeConfiguration typeConfiguration) {
        super(false, new SybaseASEXmlTableSetReturningFunctionTypeResolver(), typeConfiguration);
    }

    @Override
    protected void renderXmlTable(SqlAppender sqlAppender, XmlTableFunction.XmlTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmltable(");
        walker.render(arguments.xpath(), SqlAstNodeRenderingMode.INLINE_PARAMETERS);
        sqlAppender.appendSql(" passing ");
        walker.render(arguments.xmlDocument(), SqlAstNodeRenderingMode.INLINE_PARAMETERS);
        this.renderColumns(sqlAppender, arguments.columnsClause(), walker);
        sqlAppender.appendSql(')');
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        if (SybaseASEXmlTableFunction.isBoolean(castTarget.getJdbcMapping())) {
            return "varchar(5)";
        }
        return super.determineColumnType(castTarget, walker);
    }

    @Override
    protected void renderXmlQueryColumnDefinition(SqlAppender sqlAppender, XmlTableQueryColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" int for ordinality");
    }

    @Override
    protected void renderXmlValueColumnDefinition(SqlAppender sqlAppender, XmlTableValueColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(definition.type(), walker));
        this.renderDefaultExpression(definition.defaultExpression(), sqlAppender, walker);
        this.renderColumnPath(definition.name(), definition.xpath(), sqlAppender, walker);
    }

    @Override
    protected void renderXmlOrdinalityColumnDefinition(SqlAppender sqlAppender, XmlTableOrdinalityColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" bigint for ordinality");
    }

    public static boolean isBoolean(JdbcMapping type) {
        return switch (type.getCastType()) {
            case CastType.BOOLEAN, CastType.TF_BOOLEAN, CastType.YN_BOOLEAN, CastType.INTEGER_BOOLEAN -> true;
            default -> false;
        };
    }

    private static class SybaseASEXmlTableSetReturningFunctionTypeResolver
    extends XmlTableSetReturningFunctionTypeResolver {
        private SybaseASEXmlTableSetReturningFunctionTypeResolver() {
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> sqlAstNodes, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            XmlTableFunction.XmlTableArguments arguments = XmlTableFunction.XmlTableArguments.extract(sqlAstNodes);
            ArrayList<SelectableMapping> selectableMappings = new ArrayList<SelectableMapping>(arguments.columnsClause().getColumnDefinitions().size());
            this.addSelectableMappings(selectableMappings, arguments, converter);
            return selectableMappings.toArray(new SelectableMapping[0]);
        }

        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, XmlTableFunction.XmlTableArguments arguments, SqmToSqlAstConverter converter) {
            for (XmlTableColumnDefinition columnDefinition : arguments.columnsClause().getColumnDefinitions()) {
                if (columnDefinition instanceof XmlTableQueryColumnDefinition) {
                    XmlTableQueryColumnDefinition definition = (XmlTableQueryColumnDefinition)columnDefinition;
                    this.addSelectableMappings(selectableMappings, definition, arguments, converter);
                    continue;
                }
                if (columnDefinition instanceof XmlTableValueColumnDefinition) {
                    XmlTableValueColumnDefinition definition = (XmlTableValueColumnDefinition)columnDefinition;
                    this.addSelectableMappings(selectableMappings, definition, converter);
                    continue;
                }
                XmlTableOrdinalityColumnDefinition definition = (XmlTableOrdinalityColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
            }
        }

        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, XmlTableQueryColumnDefinition definition, XmlTableFunction.XmlTableArguments arguments, SqmToSqlAstConverter converter) {
            String documentFragment;
            Expression expression = arguments.xmlDocument();
            if (expression instanceof Literal) {
                Literal documentLiteral = (Literal)expression;
                documentFragment = documentLiteral.getJdbcMapping().getJdbcLiteralFormatter().toJdbcLiteral(documentLiteral.getLiteralValue(), converter.getCreationContext().getDialect(), converter.getCreationContext().getWrapperOptions());
            } else {
                expression = arguments.xmlDocument();
                if (expression instanceof ColumnReference) {
                    ColumnReference columnReference = (ColumnReference)expression;
                    documentFragment = columnReference.getExpressionText();
                } else {
                    throw new QueryException("Sybase ASE only supports passing a literal or column reference as XML document for xmltable() when using query columns, but got: " + String.valueOf(arguments.xmlDocument()));
                }
            }
            expression = arguments.xpath();
            if (!(expression instanceof Literal)) {
                throw new QueryException("Sybase ASE only supports passing an XPath literal to xmltable() when using query columns, but got: " + String.valueOf(arguments.xpath()));
            }
            Literal literal = (Literal)expression;
            String xpathString = (String)literal.getLiteralValue();
            String definitionPath = definition.xpath() == null ? definition.name() : definition.xpath();
            selectableMappings.add(new SelectableMappingImpl("", definition.name(), new SelectablePath(definition.name()), "xmlextract('" + xpathString + "['||cast({@}." + definition.name() + " as varchar)||']/" + definitionPath + "'," + documentFragment + ")", null, null, null, null, null, null, false, false, false, false, false, false, converter.getCreationContext().getTypeConfiguration().getBasicTypeRegistry().resolve(String.class, 2009)));
        }

        @Override
        protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
            if (SybaseASEXmlTableFunction.isBoolean(type)) {
                JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
                Dialect dialect = converter.getCreationContext().getDialect();
                WrapperOptions wrapperOptions = converter.getCreationContext().getWrapperOptions();
                Object trueValue = type.convertToRelationalValue(true);
                Object falseValue = type.convertToRelationalValue(false);
                String trueFragment = jdbcLiteralFormatter.toJdbcLiteral(trueValue, dialect, wrapperOptions);
                String falseFragment = jdbcLiteralFormatter.toJdbcLiteral(falseValue, dialect, wrapperOptions);
                selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), "case {@}." + name + " when 'true' then " + trueFragment + " when 'false' then " + falseFragment + " end", null, "varchar(5)", null, null, null, null, false, false, false, false, false, false, type));
            } else {
                super.addSelectableMapping(selectableMappings, name, type, converter);
            }
        }
    }
}

