/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;

public final class LoadedManifestData {
    private final Collection<DirEntry> directories;
    private final Path entrySequenceData;
    private final int fileCount;

    public LoadedManifestData(Collection<DirEntry> directories, Path entrySequenceData, int fileCount) {
        this.directories = Objects.requireNonNull(directories);
        this.fileCount = fileCount;
        this.entrySequenceData = Objects.requireNonNull(entrySequenceData);
    }

    public Collection<DirEntry> getDirectories() {
        return this.directories;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public Path getEntrySequenceData() {
        return this.entrySequenceData;
    }

    public File getEntrySequenceFile() {
        return new File(this.entrySequenceData.toUri());
    }

    public boolean deleteEntrySequenceFile() {
        return this.getEntrySequenceFile().delete();
    }
}

