/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.utils.Position;

public class PlayerBinary
extends Player {
    private static final String LOW_STRING = "0";
    private static final String HIGH_STRING = "1";
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final SortedMap<TimeTick, ChangeState> values = new TreeMap<TimeTick, ChangeState>();
    private ChangeState initialState;
    private final List<TimingNote> notes = new ArrayList<TimingNote>();
    private final double ymargin = 8.0;

    public PlayerBinary(String code, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype) {
        super(code, skinParam, ruler, compact, stereotype, null);
        this.suggestedHeight = 30;
    }

    private double getHeightForConstraints(StringBounder stringBounder) {
        return TimeConstraint.getHeightForConstraints(stringBounder, this.constraints);
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + (double)this.suggestedHeight + this.getHeightForNotes(stringBounder, Position.BOTTOM);
    }

    @Override
    protected StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.binary).withTOBECHANGED(this.stereotype);
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        return new IntricatedPoint(new XPoint2D(x, this.getYpos(stringBounder, HIGH_STRING)), new XPoint2D(x, this.getYpos(stringBounder, HIGH_STRING)));
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position, Stereotype stereotype) {
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.note);
        Style style = signature.withTOBECHANGED(stereotype).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        this.notes.add(new TimingNote(now, this, note, position, this.skinParam, style));
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        ChangeState cs = new ChangeState(now, comment, color, this.convert(states));
        if (now == null) {
            this.initialState = cs;
        } else {
            this.values.put(now, cs);
        }
    }

    private String[] convert(String[] states) {
        if (states.length == 1) {
            return new String[]{this.convert(states[0])};
        }
        return new String[]{this.convert(states[0]), this.convert(states[1])};
    }

    private String convert(String value) {
        if (HIGH_STRING.equals(value) || "high".equalsIgnoreCase(value)) {
            return HIGH_STRING;
        }
        return LOW_STRING;
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message, ArrowConfiguration config) {
        this.constraints.add(new TimeConstraint(2.5, tick1, tick2, message, this.skinParam, config));
    }

    private double getYpos(StringBounder stringBounder, String state) {
        if (state.equalsIgnoreCase(LOW_STRING)) {
            return this.getYlow(stringBounder);
        }
        return this.getYhigh(stringBounder);
    }

    private double getYhigh(StringBounder stringBounder) {
        return 8.0 + this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP);
    }

    private double getYlow(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + (double)this.suggestedHeight - 8.0;
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth, double specialVSpace) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                TextBlock title = PlayerBinary.this.getTitle();
                XDimension2D dim = title.calculateDimension(stringBounder);
                double y = (PlayerBinary.this.getFullHeight(stringBounder) - dim.getHeight()) / 2.0;
                title.drawU(ug.apply(UTranslate.dy(y)));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dim = PlayerBinary.this.getTitle().calculateDimension(stringBounder);
                return dim.delta(5.0, 0.0);
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerBinary.this.getContext().apply(ug);
                double lastx = 0.0;
                List<String> lastValues = PlayerBinary.this.initialState == null ? Collections.singletonList(PlayerBinary.LOW_STRING) : PlayerBinary.this.initialState.getStates();
                StringBounder stringBounder = ug.getStringBounder();
                double yhigh = PlayerBinary.this.getYhigh(stringBounder);
                double ylow = PlayerBinary.this.getYlow(stringBounder);
                ULine vline = ULine.vline(ylow - yhigh);
                for (Map.Entry ent : PlayerBinary.this.values.entrySet()) {
                    ChangeState value = (ChangeState)ent.getValue();
                    double x = PlayerBinary.this.ruler.getPosInPixel((TimeTick)ent.getKey());
                    if (lastValues.size() == 1) {
                        ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(stringBounder, lastValues.get(0)))).draw(ULine.hline(x - lastx));
                    } else {
                        for (double tmpx = lastx; tmpx < x; tmpx += 5.0) {
                            ug.apply(new UTranslate(tmpx, yhigh)).draw(vline);
                        }
                    }
                    if (!lastValues.equals(value.getStates())) {
                        ug.apply(new UTranslate(x, yhigh)).draw(vline);
                    }
                    if (value.getComment() != null) {
                        TextBlock label = PlayerBinary.this.getTextBlock(value.getComment());
                        label.drawU(ug.apply(new UTranslate(x + 2.0, yhigh)));
                    }
                    lastx = x;
                    lastValues = value.getStates();
                }
                ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(stringBounder, lastValues.get(0)))).draw(ULine.hline(PlayerBinary.this.ruler.getWidth() - lastx));
                PlayerBinary.this.drawConstraints(ug.apply(UTranslate.dy(PlayerBinary.this.getHeightForConstraints(ug.getStringBounder()))));
                PlayerBinary.this.drawNotes(ug.apply(UTranslate.dy(8.0)), Position.TOP);
                PlayerBinary.this.drawNotes(ug.apply(UTranslate.dy(PlayerBinary.this.getHeightForConstraints(stringBounder) + PlayerBinary.this.getHeightForNotes(stringBounder, Position.TOP) + (double)PlayerBinary.this.suggestedHeight - 4.0)), Position.BOTTOM);
            }
        };
    }

    protected final FontConfiguration getCommentFontConfiguration() {
        return FontConfiguration.create(this.skinParam, this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
    }

    private TextBlock getTextBlock(String value) {
        Display display = Display.getWithNewlines(this.skinParam.getPragma(), value);
        return display.create(this.getCommentFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private void drawConstraints(UGraphic ug) {
        for (TimeConstraint constraint : this.constraints) {
            constraint.drawU(ug, this.ruler);
        }
    }

    private void drawNotes(UGraphic ug, Position position) {
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            TimeTick when = note.getWhen();
            double x = when == null ? 0.0 : this.ruler.getPosInPixel(when);
            note.drawU(ug.apply(UTranslate.dx(x)));
        }
    }

    private double getHeightForNotes(StringBounder stringBounder, Position position) {
        double height = 0.0;
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            height = Math.max(height, note.getHeight(stringBounder));
        }
        return height;
    }
}

