\name{CenteredTransformInitializerFilter}
\alias{CenteredTransformInitializerFilter}
\title{CenteredTransformInitializerFilter}
\Rdversion{1.1}
\docType{class}
\description{
CenteredTransformInitializerFilter is a helper class intended to initialize the center of rotation and
the translation of Transforms having the center of rotation among
their parameters.
CenteredTransformInitializerFilter}
\details{
This class is connected to the fixed image, moving image and transform
involved in the registration. Two modes of operation are possible:
Geometrical,
Center of mass
 In the first mode, the geometrical center of the moving image is
passed as initial center of rotation to the transform and the vector
from the center of the fixed image to the center of the moving image
is passed as the initial translation. This mode basically assumes that
the anatomical objects to be registered are centered in their
respective images. Hence the best initial guess for the registration
is the one that superimposes those two centers.
In the second mode, the moments of gray level values are computed for
both images. The center of mass of the moving image is then used as
center of rotation. The vector between the two centers of mass is
passes as the initial translation to the transform. This second
approach assumes that the moments of the anatomical objects are
similar for both images and hence the best initial guess for
registration is to superimpose both mass centers. Note that this
assumption will probably not hold in multi-modality registration.
See:
itk::CenteredTransformInitializer
CenteredTransformInitializerFilter}
%C++ includes: sitkCenteredTransformInitializerFilter.h
\section{Methods}{
\describe{
\item{ CenteredTransformInitializerFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Transform Execute(const Image &fixedImage, const Image &movingImage, const Transform &transform):}{
Execute the filter on the input image
}
\item{Self GeometryOn():}{
Select between using the geometrical center of the images or using the
center of mass given by the image intensities.
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{OperationModeType GetOperationMode() const:}{}
\item{Self MomentsOn():}{
Select between using the geometrical center of the images or using the
center of mass given by the image intensities.
}
\item{Self SetOperationMode(OperationModeType OperationMode):}{}
\item{std::string ToString() const override:}{
Print ourselves out
}
\item{ ~CenteredTransformInitializerFilter() override:}{
Destructor
}
}
}
