# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_voa_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_voa_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_voa_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_voa_using_subcommand
	set -l cmd (__fish_voa_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c voa -n "__fish_voa_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_needs_command" -s h -l help -d 'Print help'
complete -c voa -n "__fish_voa_needs_command" -s V -l version -d 'Print version'
complete -c voa -n "__fish_voa_needs_command" -f -a "config" -d 'Interact with the VOA configuration for technology backends.'
complete -c voa -n "__fish_voa_needs_command" -f -a "import" -d 'Import a single verifier into a VOA hierarchy.'
complete -c voa -n "__fish_voa_needs_command" -f -a "list" -d 'List all verifiers in VOA that match provided identifiers.'
complete -c voa -n "__fish_voa_needs_command" -f -a "verify" -d 'Verify a file using suitable verifiers and signatures.'
complete -c voa -n "__fish_voa_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c voa -n "__fish_voa_using_subcommand config; and not __fish_seen_subcommand_from list show help" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand config; and not __fish_seen_subcommand_from list show help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand config; and not __fish_seen_subcommand_from list show help" -s h -l help -d 'Print help'
complete -c voa -n "__fish_voa_using_subcommand config; and not __fish_seen_subcommand_from list show help" -f -a "list" -d 'List the origins of technology settings used by OSes and specific contexts.'
complete -c voa -n "__fish_voa_using_subcommand config; and not __fish_seen_subcommand_from list show help" -f -a "show" -d 'Show OS or context-level technology settings.'
complete -c voa -n "__fish_voa_using_subcommand config; and not __fish_seen_subcommand_from list show help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from list" -s o -l output-format -d 'The output format to use.' -r -f -a "json\t'The JSON output format'
text\t'The default text output format'"
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from show" -l purpose -d 'The purpose to search for.' -r
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from show" -l context -d 'The context to search for.' -r
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from show" -s o -l output-format -d 'The output format to use.' -r -f -a "json\t'The JSON output format'
text\t'The default text output format'"
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from show" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from show" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from help" -f -a "list" -d 'List the origins of technology settings used by OSes and specific contexts.'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from help" -f -a "show" -d 'Show OS or context-level technology settings.'
complete -c voa -n "__fish_voa_using_subcommand config; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c voa -n "__fish_voa_using_subcommand import" -s c -l context -d 'The context to import for.' -r
complete -c voa -n "__fish_voa_using_subcommand import" -s i -l input -d 'The directory or file to import from.' -r
complete -c voa -n "__fish_voa_using_subcommand import" -s b -l base-path -d 'The VOA base path to write to.' -r -F
complete -c voa -n "__fish_voa_using_subcommand import" -s r -l runtime -d 'Whether to import to the runtime directory.'
complete -c voa -n "__fish_voa_using_subcommand import" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand import" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c voa -n "__fish_voa_using_subcommand list" -l context -d 'The context to search for.' -r
complete -c voa -n "__fish_voa_using_subcommand list" -s t -l technology -d 'The technology to search for.' -r
complete -c voa -n "__fish_voa_using_subcommand list" -s o -l output-format -d 'The output format to use.' -r -f -a "json\t'The JSON output format'
text\t'The default text output format'"
complete -c voa -n "__fish_voa_using_subcommand list" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c voa -n "__fish_voa_using_subcommand verify" -s o -l output-format -d 'The output format to use.' -r -f -a "json\t'The JSON output format'
text\t'The default text output format'"
complete -c voa -n "__fish_voa_using_subcommand verify" -s v -l verbose -d 'Increase logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand verify" -s q -l quiet -d 'Decrease logging verbosity'
complete -c voa -n "__fish_voa_using_subcommand verify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from config import list verify help" -f -a "config" -d 'Interact with the VOA configuration for technology backends.'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from config import list verify help" -f -a "import" -d 'Import a single verifier into a VOA hierarchy.'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from config import list verify help" -f -a "list" -d 'List all verifiers in VOA that match provided identifiers.'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from config import list verify help" -f -a "verify" -d 'Verify a file using suitable verifiers and signatures.'
complete -c voa -n "__fish_voa_using_subcommand help; and not __fish_seen_subcommand_from config import list verify help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c voa -n "__fish_voa_using_subcommand help; and __fish_seen_subcommand_from config" -f -a "list" -d 'List the origins of technology settings used by OSes and specific contexts.'
complete -c voa -n "__fish_voa_using_subcommand help; and __fish_seen_subcommand_from config" -f -a "show" -d 'Show OS or context-level technology settings.'
