/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.shaped.border.RoundedCornerBorder;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TwoColoredLineBorder
extends RoundedCornerBorder {
    private static final long serialVersionUID = 1L;
    private ColorProvider topLeftColor;
    private ColorProvider bottomRightColor;
    private boolean roundCorners;
    private boolean open;

    public TwoColoredLineBorder(ColorProvider topLeftColor, ColorProvider bottomRightColor, boolean roundCorners, boolean open) {
        super(topLeftColor, null, roundCorners ? 2 : 0, roundCorners ? 2 : 0, roundCorners && !open ? 2 : 0, roundCorners && !open ? 2 : 0, true, true, !open, true);
        this.topLeftColor = topLeftColor;
        this.bottomRightColor = bottomRightColor;
        this.roundCorners = roundCorners;
        this.open = open;
    }

    @Override
    protected void paintPolygon(Component c, Graphics2D g, Polygon polygon, int width, int height) {
        TabbedPanel tp = TabbedUtils.getParentTabbedPanel(c);
        if (tp != null) {
            Direction d = tp.getProperties().getTabAreaOrientation();
            int i = 0;
            Color c1 = this.topLeftColor.getColor();
            Color c2 = this.bottomRightColor.getColor();
            if (d == Direction.UP) {
                g.setColor(c1);
                while (i < (this.roundCorners ? 3 : 1)) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                g.setColor(c2);
                while (i < polygon.npoints - 1) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                g.setColor(c1);
                GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[0], polygon.ypoints[0]);
            } else if (d == Direction.RIGHT) {
                g.setColor(c2);
                while (i < polygon.npoints - (this.open ? 2 : (this.roundCorners ? 3 : 2))) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                g.setColor(c1);
                int k = i - 1;
                while (k < polygon.npoints - 2) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                    ++k;
                }
                GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[0], polygon.ypoints[0]);
            } else if (d == Direction.DOWN) {
                g.setColor(c2);
                while (i < (this.roundCorners ? 5 : 2)) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                g.setColor(c1);
                while (i < polygon.npoints - 1) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[0], polygon.ypoints[0]);
            } else {
                g.setColor(c1);
                while (i < (this.roundCorners ? 3 : 1)) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                g.setColor(c2);
                while (i < polygon.npoints - 1) {
                    GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
                    ++i;
                }
                g.setColor(c1);
                GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[0], polygon.ypoints[0]);
            }
        }
    }
}

