/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors.telemetry;

import java.io.Closeable;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.TelemetryCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.jvm.GCMetrics;
import org.opensearch.performanceanalyzer.commons.jvm.HeapMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.RTFMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public class RTFHeapMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements TelemetryCollector {
    private static final Logger LOG = LogManager.getLogger(RTFHeapMetricsCollector.class);
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(RTFHeapMetricsCollector.class)).samplingInterval;
    private Histogram gcCollectionEventMetrics;
    private Histogram gcCollectionTimeMetrics;
    private Histogram heapUsedMetrics;
    private MetricsRegistry metricsRegistry;
    private final String memTypeAttributeKey = "mem_type";
    private boolean metricsInitialised = false;
    private PerformanceAnalyzerController performanceAnalyzerController;
    private ConfigOverridesWrapper configOverridesWrapper;
    private Map<String, Closeable> memTypeToGaugeObservableMap;

    public RTFHeapMetricsCollector(PerformanceAnalyzerController performanceAnalyzerController, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "RTFHeapMetricsCollector", (MeasurementSet)StatMetrics.RTF_HEAP_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.RTF_HEAP_METRICS_COLLECTOR_ERROR);
        this.performanceAnalyzerController = performanceAnalyzerController;
        this.configOverridesWrapper = configOverridesWrapper;
        this.memTypeToGaugeObservableMap = new HashMap<String, Closeable>();
    }

    public void collectMetrics(long startTime) {
        if (this.performanceAnalyzerController.isCollectorDisabled(this.configOverridesWrapper, this.getCollectorName())) {
            LOG.info("RTFDisksCollector is disabled. Skipping collection.");
            this.closeOpenGaugeObservablesIfAny();
            return;
        }
        this.metricsRegistry = OpenSearchResources.INSTANCE.getMetricsRegistry();
        if (this.metricsRegistry == null) {
            LOG.error("could not get the instance of MetricsRegistry class");
            return;
        }
        this.initialiseMetricsIfNeeded();
        GCMetrics.runGCMetrics();
        LOG.debug("Executing collect metrics for RTFHeapMetricsCollector");
        this.recordMetrics();
    }

    private void closeOpenGaugeObservablesIfAny() {
        for (String key : this.memTypeToGaugeObservableMap.keySet()) {
            if (!this.memTypeToGaugeObservableMap.containsKey(key)) continue;
            try {
                Closeable observableGauge = this.memTypeToGaugeObservableMap.remove(key);
                if (observableGauge == null) continue;
                observableGauge.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close the observable gauge for key {}", (Object)key);
            }
        }
    }

    private void initialiseMetricsIfNeeded() {
        if (!this.metricsInitialised) {
            this.gcCollectionEventMetrics = this.metricsRegistry.createHistogram("gc_collection_event", "GC Collection Event PA Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.gcCollectionTimeMetrics = this.metricsRegistry.createHistogram("gc_collection_time", "GC Collection Time PA Metrics", RTFMetrics.MetricUnits.MILLISECOND.toString());
            this.heapUsedMetrics = this.metricsRegistry.createHistogram("heap_used", "GC Heap Used PA Metrics", RTFMetrics.MetricUnits.BYTE.toString());
            this.metricsInitialised = true;
        }
    }

    private void recordMetrics() {
        Tags totYoungGCTag = Tags.create().addTag(RTFMetrics.HeapDimension.MEM_TYPE.getName(), RTFMetrics.GCType.TOT_YOUNG_GC.toString());
        Tags totFullGCTag = Tags.create().addTag("mem_type", RTFMetrics.GCType.TOT_FULL_GC.toString());
        this.gcCollectionEventMetrics.record((double)GCMetrics.getTotYoungGCCollectionCount(), totYoungGCTag);
        this.gcCollectionEventMetrics.record((double)GCMetrics.getTotFullGCCollectionCount(), totFullGCTag);
        this.gcCollectionTimeMetrics.record((double)GCMetrics.getTotYoungGCCollectionTime(), totYoungGCTag);
        this.gcCollectionTimeMetrics.record((double)GCMetrics.getTotFullGCCollectionTime(), totFullGCTag);
        for (Map.Entry entry : HeapMetrics.getMemoryUsageSuppliers().entrySet()) {
            MemoryUsage memoryUsage = (MemoryUsage)((Supplier)entry.getValue()).get();
            this.heapUsedMetrics.record((double)memoryUsage.getUsed(), Tags.create().addTag("mem_type", (String)entry.getKey()));
            this.createGaugeInstanceIfNotAvailable((String)entry.getKey());
        }
    }

    private void createGaugeInstanceIfNotAvailable(String key) {
        if (!this.memTypeToGaugeObservableMap.containsKey(key)) {
            LOG.info("Gauge doesn't exist for the mem type {}", (Object)key);
            Closeable observableGauge = this.metricsRegistry.createGauge("heap_max", "Heap Max PA metrics", "", () -> this.getValue(key), Tags.create().addTag("mem_type", key));
            this.memTypeToGaugeObservableMap.put(key, observableGauge);
        }
    }

    private double getValue(String key) {
        Map memoryUsageSuppliers = HeapMetrics.getMemoryUsageSuppliers();
        MemoryUsage memoryUsage = null;
        if (memoryUsageSuppliers.get(key) != null) {
            memoryUsage = (MemoryUsage)((Supplier)memoryUsageSuppliers.get(key)).get();
        }
        return memoryUsage != null ? (double)memoryUsage.getMax() : 0.0;
    }
}

