/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.event;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.event.DatabaseEvent;
import org.firebirdsql.event.EventListener;

final class OneTimeEventListener
implements EventListener {
    private int eventCount = -1;
    private final Lock lock = new ReentrantLock();
    private final Condition receivedEvent = this.lock.newCondition();

    OneTimeEventListener() {
    }

    @Override
    public void eventOccurred(DatabaseEvent event) {
        this.lock.lock();
        try {
            if (this.eventCount == -1) {
                this.eventCount = event.getEventCount();
            }
            this.receivedEvent.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void await(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.eventCount != -1) {
                return;
            }
            if (time == 0L) {
                this.receivedEvent.await();
            } else {
                this.receivedEvent.await(time, unit);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    int getEventCount() {
        return this.eventCount;
    }
}

