/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteCurrentFrameSlotNode;
import com.oracle.truffle.js.runtime.SafeInteger;

@GeneratedBy(value=JSWriteCurrentFrameSlotNode.class)
final class JSWriteCurrentFrameSlotNodeGen
extends JSWriteCurrentFrameSlotNode {
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private JSWriteCurrentFrameSlotNodeGen(int slot, Object identifier, JavaScriptNode rhsNode) {
        super(slot, identifier, rhsNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3E) == 0 && (state_0 & 0x3F) != 0) {
            return this.execute_boolean0(state_0, frameValue);
        }
        if ((state_0 & 0x3B) == 0 && (state_0 & 0x3F) != 0) {
            return this.execute_int1(state_0, frameValue);
        }
        if ((state_0 & 0x37) == 0 && (state_0 & 0x3F) != 0) {
            return this.execute_double2(state_0, frameValue);
        }
        return this.execute_generic3(state_0, frameValue);
    }

    private Object execute_boolean0(int state_0__, VirtualFrame frameValue) {
        boolean rhsNodeValue_;
        int state_0 = state_0__;
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        if (this.isBooleanKind((Frame)frameValue)) {
            return this.doBoolean(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    private Object execute_int1(int state_0__, VirtualFrame frameValue) {
        int rhsNodeValue_;
        int state_0 = state_0__;
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        FrameSlotKind kind__ = this.getFrameDescriptor((Frame)frameValue).getSlotKind(this.slot);
        if (this.isIntegerKind((Frame)frameValue, kind__) || this.isLongKind((Frame)frameValue, kind__) || this.isDoubleKind((Frame)frameValue, kind__)) {
            return this.doInteger(frameValue, rhsNodeValue_, kind__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    private Object execute_double2(int state_0__, VirtualFrame frameValue) {
        double rhsNodeValue_;
        int state_0 = state_0__;
        int rhsNodeValue_int = 0;
        try {
            if ((state_0 & 0x180) == 0 && (state_0 & 0x3F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else if ((state_0 & 0x140) == 0 && (state_0 & 0x3F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1C0) >>> 6, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        if (this.isDoubleKind((Frame)frameValue)) {
            return this.doDouble(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, (state_0 & 0x140) == 0 && (state_0 & 0x3F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_);
    }

    private Object execute_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object rhsNodeValue_ = this.rhsNode.execute(frameValue);
        if ((state_0 & 0x3F) != 0) {
            int rhsNodeValue__;
            if ((state_0 & 1) != 0 && rhsNodeValue_ instanceof Boolean) {
                rhsNodeValue__ = ((Boolean)rhsNodeValue_).booleanValue();
                if (this.isBooleanKind((Frame)frameValue)) {
                    return this.doBoolean(frameValue, rhsNodeValue__ != 0);
                }
            }
            if ((state_0 & 4) != 0 && rhsNodeValue_ instanceof Integer) {
                rhsNodeValue__ = (Integer)rhsNodeValue_;
                FrameSlotKind kind__ = this.getFrameDescriptor((Frame)frameValue).getSlotKind(this.slot);
                if (this.isIntegerKind((Frame)frameValue, kind__) || this.isLongKind((Frame)frameValue, kind__) || this.isDoubleKind((Frame)frameValue, kind__)) {
                    return this.doInteger(frameValue, rhsNodeValue__, kind__);
                }
            }
            if ((state_0 & 0x10) != 0 && rhsNodeValue_ instanceof SafeInteger) {
                SafeInteger rhsNodeValue__2 = (SafeInteger)rhsNodeValue_;
                if (this.isLongKind((Frame)frameValue)) {
                    return this.doSafeInteger(frameValue, rhsNodeValue__2);
                }
            }
            if ((state_0 & 0x20) != 0 && rhsNodeValue_ instanceof Long) {
                long rhsNodeValue__3 = (Long)rhsNodeValue_;
                return this.doLong(frameValue, rhsNodeValue__3);
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C0) >>> 6, rhsNodeValue_)) {
                double rhsNodeValue__4 = JSTypesGen.asImplicitDouble((state_0 & 0x1C0) >>> 6, rhsNodeValue_);
                if (this.isDoubleKind((Frame)frameValue)) {
                    return this.doDouble(frameValue, rhsNodeValue__4);
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doObject(frameValue, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean rhsNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 1) != 0 && this.isBooleanKind((Frame)frameValue)) {
            return this.doBoolean(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        double rhsNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        int rhsNodeValue_int = 0;
        try {
            if ((state_0 & 0x180) == 0 && (state_0 & 0x3F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else if ((state_0 & 0x140) == 0 && (state_0 & 0x3F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1C0) >>> 6, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 8) != 0 && this.isDoubleKind((Frame)frameValue)) {
            return this.doDouble(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(frameValue, (state_0 & 0x140) == 0 && (state_0 & 0x3F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        FrameSlotKind kind__;
        int rhsNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 4) != 0 && (this.isIntegerKind((Frame)frameValue, kind__ = this.getFrameDescriptor((Frame)frameValue).getSlotKind(this.slot)) || this.isLongKind((Frame)frameValue, kind__) || this.isDoubleKind((Frame)frameValue, kind__))) {
            return this.doInteger(frameValue, rhsNodeValue_, kind__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    void executeEvaluated(VirtualFrame frameValue, Object rhsNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3F) != 0) {
            int rhsNodeValue_;
            if ((state_0 & 1) != 0 && rhsNodeValue instanceof Boolean) {
                rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
                if (this.isBooleanKind((Frame)frameValue)) {
                    this.doBoolean(frameValue, rhsNodeValue_ != 0);
                    return;
                }
            }
            if ((state_0 & 4) != 0 && rhsNodeValue instanceof Integer) {
                rhsNodeValue_ = (Integer)rhsNodeValue;
                FrameSlotKind kind__ = this.getFrameDescriptor((Frame)frameValue).getSlotKind(this.slot);
                if (this.isIntegerKind((Frame)frameValue, kind__) || this.isLongKind((Frame)frameValue, kind__) || this.isDoubleKind((Frame)frameValue, kind__)) {
                    this.doInteger(frameValue, rhsNodeValue_, kind__);
                    return;
                }
            }
            if ((state_0 & 0x10) != 0 && rhsNodeValue instanceof SafeInteger) {
                SafeInteger rhsNodeValue_2 = (SafeInteger)rhsNodeValue;
                if (this.isLongKind((Frame)frameValue)) {
                    this.doSafeInteger(frameValue, rhsNodeValue_2);
                    return;
                }
            }
            if ((state_0 & 0x20) != 0 && rhsNodeValue instanceof Long) {
                long rhsNodeValue_3 = (Long)rhsNodeValue;
                this.doLong(frameValue, rhsNodeValue_3);
                return;
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C0) >>> 6, rhsNodeValue)) {
                double rhsNodeValue_4 = JSTypesGen.asImplicitDouble((state_0 & 0x1C0) >>> 6, rhsNodeValue);
                if (this.isDoubleKind((Frame)frameValue)) {
                    this.doDouble(frameValue, rhsNodeValue_4);
                    return;
                }
            }
            if ((state_0 & 2) != 0) {
                this.doObject(frameValue, rhsNodeValue);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, rhsNodeValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0x3B) == 0 && (state_0 & 0x3F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state_0 & 0x37) == 0 && (state_0 & 0x3F) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            if ((state_0 & 0x3E) == 0 && (state_0 & 0x3F) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object rhsNodeValue) {
        int doubleCast0;
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0 && rhsNodeValue instanceof Boolean) {
            boolean rhsNodeValue_ = (Boolean)rhsNodeValue;
            if (this.isBooleanKind((Frame)frameValue)) {
                this.state_0_ = state_0 |= 1;
                return this.doBoolean(frameValue, rhsNodeValue_);
            }
        }
        FrameSlotKind kind__ = null;
        if ((state_0 & 0xA) == 0 && rhsNodeValue instanceof Integer) {
            int rhsNodeValue_ = (Integer)rhsNodeValue;
            kind__ = this.getFrameDescriptor((Frame)frameValue).getSlotKind(this.slot);
            if (this.isIntegerKind((Frame)frameValue, kind__) || this.isLongKind((Frame)frameValue, kind__) || this.isDoubleKind((Frame)frameValue, kind__)) {
                this.state_0_ = state_0 |= 4;
                return this.doInteger(frameValue, rhsNodeValue_, kind__);
            }
        }
        if ((state_0 & 0xA) == 0 && rhsNodeValue instanceof SafeInteger) {
            SafeInteger rhsNodeValue_ = (SafeInteger)rhsNodeValue;
            if (this.isLongKind((Frame)frameValue)) {
                this.state_0_ = state_0 |= 0x10;
                return this.doSafeInteger(frameValue, rhsNodeValue_);
            }
        }
        if ((state_0 & 2) == 0 && rhsNodeValue instanceof Long) {
            long rhsNodeValue_ = (Long)rhsNodeValue;
            this.state_0_ = state_0 |= 0x20;
            return this.doLong(frameValue, rhsNodeValue_);
        }
        if ((state_0 & 2) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(rhsNodeValue)) != 0) {
            double rhsNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, rhsNodeValue);
            if (this.isDoubleKind((Frame)frameValue)) {
                state_0 &= 0xFFFFFFEB;
                state_0 |= doubleCast0 << 6;
                this.state_0_ = state_0 |= 8;
                return this.doDouble(frameValue, rhsNodeValue_);
            }
        }
        state_0 &= 0xFFFFFFC2;
        this.state_0_ = state_0 |= 2;
        return this.doObject(frameValue, rhsNodeValue);
    }

    @NeverDefault
    public static JSWriteCurrentFrameSlotNode create(int slot, Object identifier, JavaScriptNode rhsNode) {
        return new JSWriteCurrentFrameSlotNodeGen(slot, identifier, rhsNode);
    }
}

