/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib.fastpath;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;

@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerTypes.class)
public abstract class PyNumberMultiplyFastPathsBase
extends BinaryOpNode {
    @Specialization(rewriteOn={ArithmeticException.class})
    public static int doII(int x, int y) throws ArithmeticException {
        return Math.multiplyExact(x, y);
    }

    @Specialization(replaces={"doII"})
    public static long doIIL(int x, int y) {
        return (long)x * (long)y;
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    public static long doLL(long x, long y) {
        return Math.multiplyExact(x, y);
    }

    @Specialization(replaces={"doLL"})
    public static Object doLongWithOverflow(long x, long y, @Bind Node inliningTarget) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return PFactory.createInt(PythonLanguage.get(inliningTarget), IntBuiltins.MulNode.mul(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
        }
        return r;
    }

    @Specialization
    public static double doDL(double left, long right) {
        return left * (double)right;
    }

    @Specialization
    public static double doLD(long left, double right) {
        return (double)left * right;
    }

    @Specialization
    public static double doDD(double left, double right) {
        return left * right;
    }
}

