﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dynamodb/DynamoDB_EXPORTS.h>
#include <aws/dynamodb/model/AttributeValue.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DynamoDB {
namespace Model {

/**
 * <p>Specifies an item and related attribute values to retrieve in a
 * <code>TransactGetItem</code> object.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Get">AWS API
 * Reference</a></p>
 */
class Get {
 public:
  AWS_DYNAMODB_API Get() = default;
  AWS_DYNAMODB_API Get(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API Get& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A map of attribute names to <code>AttributeValue</code> objects that
   * specifies the primary key of the item to retrieve.</p>
   */
  inline const Aws::Map<Aws::String, AttributeValue>& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::Map<Aws::String, AttributeValue>>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::Map<Aws::String, AttributeValue>>
  Get& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  template <typename KeyKeyT = Aws::String, typename KeyValueT = AttributeValue>
  Get& AddKey(KeyKeyT&& key, KeyValueT&& value) {
    m_keyHasBeenSet = true;
    m_key.emplace(std::forward<KeyKeyT>(key), std::forward<KeyValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the table from which to retrieve the specified item. You can also
   * provide the Amazon Resource Name (ARN) of the table in this parameter.</p>
   */
  inline const Aws::String& GetTableName() const { return m_tableName; }
  inline bool TableNameHasBeenSet() const { return m_tableNameHasBeenSet; }
  template <typename TableNameT = Aws::String>
  void SetTableName(TableNameT&& value) {
    m_tableNameHasBeenSet = true;
    m_tableName = std::forward<TableNameT>(value);
  }
  template <typename TableNameT = Aws::String>
  Get& WithTableName(TableNameT&& value) {
    SetTableName(std::forward<TableNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A string that identifies one or more attributes of the specified item to
   * retrieve from the table. The attributes in the expression must be separated by
   * commas. If no attribute names are specified, then all attributes of the
   * specified item are returned. If any of the requested attributes are not found,
   * they do not appear in the result.</p>
   */
  inline const Aws::String& GetProjectionExpression() const { return m_projectionExpression; }
  inline bool ProjectionExpressionHasBeenSet() const { return m_projectionExpressionHasBeenSet; }
  template <typename ProjectionExpressionT = Aws::String>
  void SetProjectionExpression(ProjectionExpressionT&& value) {
    m_projectionExpressionHasBeenSet = true;
    m_projectionExpression = std::forward<ProjectionExpressionT>(value);
  }
  template <typename ProjectionExpressionT = Aws::String>
  Get& WithProjectionExpression(ProjectionExpressionT&& value) {
    SetProjectionExpression(std::forward<ProjectionExpressionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>One or more substitution tokens for attribute names in the
   * ProjectionExpression parameter.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetExpressionAttributeNames() const { return m_expressionAttributeNames; }
  inline bool ExpressionAttributeNamesHasBeenSet() const { return m_expressionAttributeNamesHasBeenSet; }
  template <typename ExpressionAttributeNamesT = Aws::Map<Aws::String, Aws::String>>
  void SetExpressionAttributeNames(ExpressionAttributeNamesT&& value) {
    m_expressionAttributeNamesHasBeenSet = true;
    m_expressionAttributeNames = std::forward<ExpressionAttributeNamesT>(value);
  }
  template <typename ExpressionAttributeNamesT = Aws::Map<Aws::String, Aws::String>>
  Get& WithExpressionAttributeNames(ExpressionAttributeNamesT&& value) {
    SetExpressionAttributeNames(std::forward<ExpressionAttributeNamesT>(value));
    return *this;
  }
  template <typename ExpressionAttributeNamesKeyT = Aws::String, typename ExpressionAttributeNamesValueT = Aws::String>
  Get& AddExpressionAttributeNames(ExpressionAttributeNamesKeyT&& key, ExpressionAttributeNamesValueT&& value) {
    m_expressionAttributeNamesHasBeenSet = true;
    m_expressionAttributeNames.emplace(std::forward<ExpressionAttributeNamesKeyT>(key),
                                       std::forward<ExpressionAttributeNamesValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Map<Aws::String, AttributeValue> m_key;

  Aws::String m_tableName;

  Aws::String m_projectionExpression;

  Aws::Map<Aws::String, Aws::String> m_expressionAttributeNames;
  bool m_keyHasBeenSet = false;
  bool m_tableNameHasBeenSet = false;
  bool m_projectionExpressionHasBeenSet = false;
  bool m_expressionAttributeNamesHasBeenSet = false;
};

}  // namespace Model
}  // namespace DynamoDB
}  // namespace Aws
