/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class ClassSuperHierarchyInitializer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingWarningPrinter;
    private final WarningPrinter dependencyWarningPrinter;

    public ClassSuperHierarchyInitializer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this(programClassPool, libraryClassPool, null, null);
    }

    public ClassSuperHierarchyInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter missingWarningPrinter, WarningPrinter dependencyWarningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.missingWarningPrinter = missingWarningPrinter;
        this.dependencyWarningPrinter = dependencyWarningPrinter;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.superClassConstantAccept(this);
        programClass.interfaceConstantsAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        String className = libraryClass.getName();
        String superClassName = libraryClass.superClassName;
        if (superClassName != null) {
            libraryClass.superClass = this.findClass(className, superClassName);
        }
        if (libraryClass.interfaceNames != null) {
            String[] interfaceNames = libraryClass.interfaceNames;
            Clazz[] interfaceClasses = new Clazz[interfaceNames.length];
            for (int index = 0; index < interfaceNames.length; ++index) {
                interfaceClasses[index] = this.findClass(className, interfaceNames[index]);
            }
            libraryClass.interfaceClasses = interfaceClasses;
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(clazz.getName(), classConstant.getName(clazz));
    }

    private Clazz findClass(String referencingClassName, String name) {
        Clazz clazz = this.programClassPool.getClass(name);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(name);
            if (clazz == null && this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print(referencingClassName, name, "Warning: " + ClassUtil.externalClassName(referencingClassName) + ": can't find superclass or interface " + ClassUtil.externalClassName(name));
            }
        } else if (this.dependencyWarningPrinter != null) {
            this.dependencyWarningPrinter.print(referencingClassName, name, "Warning: library class " + ClassUtil.externalClassName(referencingClassName) + " extends or implements program class " + ClassUtil.externalClassName(name));
        }
        return clazz;
    }
}

