/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

public final class JsAstUtils {
    private JsAstUtils() {
    }

    @NotNull
    public static JsExpression notOptimized(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(0);
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation unary = (JsUnaryOperation)expression2;
            if (unary.getOperator() == JsUnaryOperator.NOT) {
                JsExpression jsExpression = unary.getArg();
                if (jsExpression == null) {
                    JsAstUtils.$$$reportNull$$$0(1);
                }
                return jsExpression;
            }
        } else if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)expression2;
            switch (binary.getOperator()) {
                case AND: {
                    return JsAstUtils.or(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                }
                case OR: {
                    return JsAstUtils.and(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                }
                case EQ: {
                    return new JsBinaryOperation(JsBinaryOperator.NEQ, binary.getArg1(), binary.getArg2());
                }
                case NEQ: {
                    return new JsBinaryOperation(JsBinaryOperator.EQ, binary.getArg1(), binary.getArg2());
                }
                case REF_EQ: {
                    return JsAstUtils.inequality(binary.getArg1(), binary.getArg2());
                }
                case REF_NEQ: {
                    return JsAstUtils.equality(binary.getArg1(), binary.getArg2());
                }
                case LT: {
                    return JsAstUtils.greaterThanEq(binary.getArg1(), binary.getArg2());
                }
                case LTE: {
                    return JsAstUtils.greaterThan(binary.getArg1(), binary.getArg2());
                }
                case GT: {
                    return JsAstUtils.lessThanEq(binary.getArg1(), binary.getArg2());
                }
                case GTE: {
                    return JsAstUtils.lessThan(binary.getArg1(), binary.getArg2());
                }
            }
        }
        return JsAstUtils.not(expression2);
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(2);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(3);
        }
        return new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(4);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(5);
        }
        return new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(6);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(7);
        }
        return new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
    }

    @NotNull
    private static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(8);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(9);
        }
        return new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
    }

    @NotNull
    private static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(10);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(11);
        }
        return new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
    }

    @NotNull
    private static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(12);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(13);
        }
        return new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
    }

    @NotNull
    private static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(14);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(15);
        }
        return new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
    }

    @NotNull
    private static JsBinaryOperation greaterThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(16);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(17);
        }
        return new JsBinaryOperation(JsBinaryOperator.GTE, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(18);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(19);
        }
        return new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
    }

    public static JsStatement asSyntheticStatement(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(20);
        }
        JsExpressionStatement statement = new JsExpressionStatement(expression2);
        MetadataProperties.setSynthetic(statement, true);
        return statement;
    }

    @Nullable
    public static Pair<JsExpression, JsExpression> decomposeAssignment(@NotNull JsExpression expr) {
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(21);
        }
        if (!(expr instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expr;
        if (binary.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        return new Pair((Object)binary.getArg1(), (Object)binary.getArg2());
    }

    @Nullable
    public static Pair<JsName, JsExpression> decomposeAssignmentToVariable(@NotNull JsExpression expr) {
        Pair<JsExpression, JsExpression> assignment;
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(22);
        }
        if ((assignment = JsAstUtils.decomposeAssignment(expr)) == null || !(assignment.getFirst() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef nameRef = (JsNameRef)assignment.getFirst();
        if (nameRef.getName() == null || nameRef.getQualifier() != null) {
            return null;
        }
        return new Pair((Object)nameRef.getName(), assignment.getSecond());
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(23);
        }
        return new JsPrefixOperation(JsUnaryOperator.NOT, expression2);
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name, @Nullable JsExpression expr) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(24);
        }
        return new JsVars(new JsVars.JsVar(name, expr));
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        if (expressions == null) {
            JsAstUtils.$$$reportNull$$$0(25);
        }
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            JsExpression jsExpression = expressions.get(0);
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$0(26);
            }
            return jsExpression;
        }
        JsExpression result = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            result = new JsBinaryOperation(JsBinaryOperator.COMMA, result, expressions.get(i));
        }
        JsExpression jsExpression = result;
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(27);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op1";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op2";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "notOptimized";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notOptimized";
                break;
            }
            case 1: 
            case 26: 
            case 27: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "equality";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inequality";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lessThanEq";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lessThan";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "greaterThan";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "greaterThanEq";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assignment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "asSyntheticStatement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignment";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignmentToVariable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newVar";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

