/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ5\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0013H\u0002J!\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkGetter", "property", "checkSetter", "checkAccessorForDelegatedProperty", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)V", "isImplicitDelegateAccessor", "", "isLegallyAbstract", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyAccessorsTypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyAccessorsTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,137:1\n23#2:138\n23#2:139\n23#2:140\n14#2:141\n81#2:143\n78#2:144\n70#2:145\n14#2:147\n75#2:148\n73#2:149\n1#3:142\n34#4:146\n37#4:150\n*S KotlinDebug\n*F\n+ 1 FirPropertyAccessorsTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker\n*L\n42#1:138\n77#1:139\n83#1:140\n133#1:141\n134#1:143\n134#1:144\n134#1:145\n134#1:147\n134#1:148\n134#1:149\n134#1:146\n134#1:150\n*E\n"})
public final class FirPropertyAccessorsTypesChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyAccessorsTypesChecker INSTANCE = new FirPropertyAccessorsTypesChecker();

    private FirPropertyAccessorsTypesChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.checkGetter(context2, reporter, declaration);
        this.checkSetter(context2, reporter, declaration);
    }

    private final void checkGetter(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2) {
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor getter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        this.checkAccessorForDelegatedProperty(context2, reporter, property2, getter2);
        if (this.isImplicitDelegateAccessor(getter2)) {
            return;
        }
        FirMemberDeclaration $this$visibility$iv = getter2;
        boolean $i$f$getVisibility = false;
        Visibility visibility = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = property2;
        $i$f$getVisibility = false;
        if (!Intrinsics.areEqual(visibility, $this$visibility$iv.getStatus().getVisibility())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), null, 8, null);
        }
        if (property2.getSymbol().getCallableId().getClassId() != null && getter2.getBody() != null && property2.getDelegate() == null && this.isLegallyAbstract(context2, property2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)getter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), null, 8, null);
        }
        FirTypeRef getterReturnTypeRef = getter2.getReturnTypeRef();
        KtSourceElement ktSourceElement = getterReturnTypeRef.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        ConeKotlinType getterReturnType = FirTypeUtilsKt.getConeType(getterReturnTypeRef);
        if (propertyType instanceof ConeErrorType || getterReturnType instanceof ConeErrorType) {
            return;
        }
        if (!Intrinsics.areEqual(getterReturnType, FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()))) {
            KtSourceElement getterReturnTypeSource = getterReturnTypeRef.getSource();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), (Object)propertyType, (Object)getterReturnType, null, 32, null);
        }
    }

    private final void checkSetter(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2) {
        ConeKotlinType setterReturnType;
        FirValueParameter valueSetterParameter;
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor setter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        if (property2.isVal()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), null, 8, null);
        }
        this.checkAccessorForDelegatedProperty(context2, reporter, property2, setter2);
        if (this.isImplicitDelegateAccessor(setter2)) {
            return;
        }
        FirMemberDeclaration $this$visibility$iv = setter2;
        boolean $i$f$getVisibility = false;
        Visibility visibility = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = property2;
        $i$f$getVisibility = false;
        Integer visibilityCompareResult = visibility.compareTo($this$visibility$iv.getStatus().getVisibility());
        if (visibilityCompareResult == null || visibilityCompareResult > 0) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), null, 8, null);
        }
        if (property2.getSymbol().getCallableId().getClassId() != null && property2.getDelegate() == null) {
            boolean isLegallyAbstract = this.isLegallyAbstract(context2, property2);
            FirMemberDeclaration $this$visibility$iv2 = setter2;
            boolean $i$f$getVisibility2 = false;
            if (Intrinsics.areEqual($this$visibility$iv2.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) {
                $this$visibility$iv2 = property2;
                $i$f$getVisibility2 = false;
                if (!Intrinsics.areEqual($this$visibility$iv2.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) {
                    if (isLegallyAbstract) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), null, 8, null);
                    } else if (!DeclarationUtilsKt.isEffectivelyFinal(property2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), null, 8, null);
                    }
                }
            }
            if (isLegallyAbstract && setter2.getBody() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), null, 8, null);
            }
        }
        if ((valueSetterParameter = CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
            return;
        }
        ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
        KtSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
        if (propertyType instanceof ConeErrorType || valueSetterType instanceof ConeErrorType) {
            return;
        }
        if (!Intrinsics.areEqual(TypeUtilsKt.withAttributes(valueSetterType, ConeAttributes.Companion.getEmpty()), TypeUtilsKt.withAttributes(propertyType, ConeAttributes.Companion.getEmpty())) && !ConeTypeUtilsKt.hasError(valueSetterType)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), (Object)propertyType, (Object)valueSetterType, null, 32, null);
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit(setterReturnType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef())))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), null, 8, null);
        }
    }

    private final void checkAccessorForDelegatedProperty(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2, FirPropertyAccessor accessor) {
        if (property2.getDelegateFieldSymbol() != null && accessor.getBody() != null) {
            KtSourceElement ktSourceElement = accessor.getSource();
            if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)accessor.getSource(), FirErrors.INSTANCE.getACCESSOR_FOR_DELEGATED_PROPERTY(), null, 8, null);
            }
        }
    }

    private final boolean isImplicitDelegateAccessor(FirPropertyAccessor $this$isImplicitDelegateAccessor) {
        KtSourceElement ktSourceElement = $this$isImplicitDelegateAccessor.getSource();
        return Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLegallyAbstract(CheckerContext context2, FirProperty property2) {
        FirMemberDeclaration $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() != Modality.ABSTRACT) return false;
        boolean bl = true;
        if (!bl) return false;
        FirClassSymbol<?> it = FirHelpersKt.findClosestClassOrObject(context2);
        boolean bl2 = false;
        if (!(it instanceof FirRegularClassSymbol)) return false;
        FirRegularClassSymbol $this$canHaveAbstractDeclaration$iv = (FirRegularClassSymbol)it;
        boolean $i$f$getCanHaveAbstractDeclaration = false;
        FirRegularClass $this$canHaveAbstractDeclaration$iv$iv = (FirRegularClass)$this$canHaveAbstractDeclaration$iv.getFir();
        boolean $i$f$getCanHaveAbstractDeclaration2 = false;
        FirClass $this$isInterface$iv$iv$iv = $this$canHaveAbstractDeclaration$iv$iv;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv$iv$iv = $this$isInterface$iv$iv$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv$iv$iv == ClassKind.INTERFACE) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        FirMemberDeclaration $this$isAbstract$iv$iv$iv = $this$canHaveAbstractDeclaration$iv$iv;
        boolean $i$f$isAbstract2 = false;
        if ($this$isAbstract$iv$iv$iv.getStatus().getModality() == Modality.ABSTRACT) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        FirRegularClass $this$isSealed$iv$iv$iv = $this$canHaveAbstractDeclaration$iv$iv;
        boolean $i$f$isSealed = false;
        if ($this$isSealed$iv$iv$iv.getStatus().getModality() == Modality.SEALED) {
            return true;
        }
        boolean bl5 = false;
        if (bl5) return true;
        FirClass $this$isEnumClass$iv$iv$iv = $this$canHaveAbstractDeclaration$iv$iv;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv$iv$iv = $this$isEnumClass$iv$iv$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }
}

