/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.backend.BackendRecentFileEventsController;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/recentFiles/backend/RecentFilesVcsStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "intellij.platform.recentFiles.backend"})
@SourceDebugExtension(value={"SMAP\nRecentFilesVcsStatusListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentFilesVcsStatusListener.kt\ncom/intellij/platform/recentFiles/backend/RecentFilesVcsStatusListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,23:1\n24#2:24\n68#2,4:25\n24#2:29\n68#2,4:30\n*S KotlinDebug\n*F\n+ 1 RecentFilesVcsStatusListener.kt\ncom/intellij/platform/recentFiles/backend/RecentFilesVcsStatusListener\n*L\n15#1:24\n15#1:25,4\n20#1:29\n20#1:30,4\n*E\n"})
public final class RecentFilesVcsStatusListener
implements FileStatusListener {
    @NotNull
    private final Project project;

    public RecentFilesVcsStatusListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileStatus fileStatus = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus newStatus = fileStatus;
        RecentFilesVcsStatusListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RecentFilesVcsStatusListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("Files to apply changes for: " + virtualFile.getName() + " with new VCS status " + newStatus);
        }
        BackendRecentFileEventsController.INSTANCE.applyRelevantEventsToModel(CollectionsKt.listOf((Object)virtualFile), FileChangeKind.UPDATED, this.project);
    }

    public void fileStatusesChanged() {
        RecentFilesVcsStatusListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RecentFilesVcsStatusListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("Update all existing files in model on VCS status change in project " + this.project.getName());
        }
        BackendRecentFileEventsController.INSTANCE.updateAllExistingFilesInModel(this.project);
    }
}

