/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "", "length", "", "hash", "", "<init>", "(J[B)V", "getLength", "()J", "getHash", "()[B", "equals", "", "other", "hashCode", "", "toString", "", "incremental-compilation-impl"})
public final class FileSnapshot {
    private final long length;
    @NotNull
    private final byte[] hash;

    public FileSnapshot(long length, @NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter(hash, "hash");
        this.length = length;
        this.hash = hash;
    }

    public final long getLength() {
        return this.length;
    }

    @NotNull
    public final byte[] getHash() {
        return this.hash;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.jetbrains.kotlin.incremental.snapshots.FileSnapshot");
        FileSnapshot cfr_ignored_0 = (FileSnapshot)other;
        if (this.length != ((FileSnapshot)other).length) {
            return false;
        }
        return Arrays.equals(this.hash, ((FileSnapshot)other).hash);
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.length);
        result2 = 31 * result2 + Arrays.hashCode(this.hash);
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("FileSnapshot(length=").append(this.length).append(", hash=");
        String string2 = Arrays.toString(this.hash);
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return stringBuilder.append(string2).append(')').toString();
    }
}

