/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002 !B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\b*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0016\u001a\u00020\b*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u001a\u0010\u001b\u001a\u0004\u0018\u00010\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u0004\u0018\u00010\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "closureBuilders", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "scriptingMode", "", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Ljava/util/Map;Z)V", "getFunctionClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getClassClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getClosure", "includeInParent", "", "builder", "closureBuilder", "getClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "collectPotentiallyCapturedTypeParameters", "parentClosureBuilder", "getParentClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilderOrNull", "getClosureBuilderOrNull", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1#2:357\n382#3,3:358\n385#3,4:365\n382#3,3:369\n385#3,4:374\n295#4,2:361\n1869#4,2:363\n1869#4,2:372\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator\n*L\n177#1:358,3\n177#1:365,4\n202#1:369,3\n202#1:374,4\n193#1:361,2\n195#1:363,2\n207#1:372,2\n*E\n"})
public final class ClosureAnnotator {
    @NotNull
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;
    private final boolean scriptingMode;

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull IrDeclaration declaration, @NotNull Map<IrDeclaration, ClosureBuilder> closureBuilders, boolean scriptingMode) {
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(closureBuilders, (String)"closureBuilders");
        this.closureBuilders = closureBuilders;
        this.scriptingMode = scriptingMode;
        IrVisitor irVisitor = new ClosureCollectorVisitor();
        ClosureBuilder closureBuilder = this.getClosureBuilderOrNull(declaration);
        if (closureBuilder == null) {
            closureBuilder = this.getParentClosureBuilder(declaration);
        }
        irElement.accept(irVisitor, closureBuilder);
    }

    public /* synthetic */ ClosureAnnotator(IrElement irElement, IrDeclaration irDeclaration, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(irElement, irDeclaration, map, bl);
    }

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getClosure(declaration);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getClosure(declaration);
    }

    private final Closure getClosure(IrDeclaration declaration) {
        ClosureBuilder closureBuilder = this.closureBuilders.get(declaration);
        if (closureBuilder == null) {
            boolean bl = false;
            throw new AssertionError((Object)("No closure builder for passed declaration " + IrUtilsKt.ir2string(declaration) + '.'));
        }
        return closureBuilder.buildClosure();
    }

    private final void includeInParent(ClosureBuilder builder) {
        ClosureBuilder parentBuilder = this.getParentClosureBuilder(builder.getOwner());
        if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
            parentBuilder.include(builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ClosureBuilder getClosureBuilder(IrClass $this$closureBuilder) {
        Object object;
        void $this$getOrPut$iv;
        Map<IrDeclaration, ClosureBuilder> map = this.closureBuilders;
        IrClass key$iv = $this$closureBuilder;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Object v1;
            ClosureBuilder closureBuilder;
            block10: {
                boolean bl = false;
                closureBuilder = new ClosureBuilder($this$closureBuilder);
                this.collectPotentiallyCapturedTypeParameters(closureBuilder);
                closureBuilder.declareVariable($this$closureBuilder.getThisReceiver());
                if ($this$closureBuilder.isInner()) {
                    IrValueParameter irValueParameter;
                    IrDeclarationParent parent = $this$closureBuilder.getParent();
                    if (parent instanceof IrClass) {
                        irValueParameter = ((IrClass)parent).getThisReceiver();
                    } else if (parent instanceof IrScript) {
                        irValueParameter = ((IrScript)parent).getThisReceiver();
                    } else {
                        throw new IllegalStateException(("unexpected parent " + parent).toString());
                    }
                    IrValueParameter receiver = irValueParameter;
                    closureBuilder.declareVariable(receiver);
                    this.includeInParent(closureBuilder);
                }
                Iterable $this$firstOrNull$iv = $this$closureBuilder.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            IrDeclaration irDeclaration = v1;
            if (irDeclaration != null) {
                IrDeclaration it = irDeclaration;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                IrConstructor constructor = (IrConstructor)it;
                Iterable $this$forEach$iv = IrUtilsKt.getNonDispatchParameters(constructor);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter v = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    closureBuilder.declareVariable(v);
                }
            }
            ClosureBuilder answer$iv = closureBuilder;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ClosureBuilder)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ClosureBuilder getClosureBuilder(IrFunction $this$closureBuilder) {
        Object object;
        void $this$getOrPut$iv;
        Map<IrDeclaration, ClosureBuilder> map = this.closureBuilders;
        IrFunction key$iv = $this$closureBuilder;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ClosureBuilder closureBuilder = new ClosureBuilder($this$closureBuilder);
            this.collectPotentiallyCapturedTypeParameters(closureBuilder);
            Iterable $this$forEach$iv = $this$closureBuilder.getParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                closureBuilder.declareVariable(it);
            }
            closureBuilder.seeType($this$closureBuilder.getReturnType());
            if ($this$closureBuilder instanceof IrConstructor) {
                IrDeclarationParent irDeclarationParent = $this$closureBuilder.getParent();
                Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                IrClass constructedClass = (IrClass)irDeclarationParent;
                closureBuilder.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder classBuilder = this.getClosureBuilder(constructedClass);
                closureBuilder.include(classBuilder);
            }
            ClosureBuilder answer$iv = closureBuilder;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ClosureBuilder)object;
    }

    private final void collectPotentiallyCapturedTypeParameters(ClosureBuilder closureBuilder) {
        ClosureBuilder current = this.getParentClosureBuilder(closureBuilder.getOwner());
        while (current != null) {
            IrDeclaration container = current.getOwner();
            if (container instanceof IrTypeParametersContainer) {
                for (IrTypeParameter typeParameter : ((IrTypeParametersContainer)container).getTypeParameters()) {
                    closureBuilder.addPotentiallyCapturedTypeParameter(typeParameter);
                }
            }
            current = this.getParentClosureBuilder(container);
        }
    }

    private final ClosureBuilder getParentClosureBuilder(IrDeclaration $this$parentClosureBuilder) {
        IrDeclarationParent p = $this$parentClosureBuilder.getParent();
        return p instanceof IrClass ? this.getClosureBuilder((IrClass)p) : (p instanceof IrFunction ? this.getClosureBuilder((IrFunction)p) : (p instanceof IrDeclaration ? this.getParentClosureBuilder((IrDeclaration)((Object)p)) : null));
    }

    private final ClosureBuilder getClosureBuilderOrNull(IrDeclaration $this$closureBuilderOrNull) {
        IrDeclaration irDeclaration = $this$closureBuilderOrNull;
        return irDeclaration instanceof IrClass ? this.getClosureBuilder((IrClass)$this$closureBuilderOrNull) : (irDeclaration instanceof IrFunction ? this.getClosureBuilder((IrFunction)$this$closureBuilderOrNull) : null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "capturedValues", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "declaredValues", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "potentiallyCapturedTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "capturedTypeParameters", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "buildClosure", "collectConnectedClosures", "", "updateFromIncluded", "", "include", "", "includingBuilder", "declareVariable", "valueDeclaration", "seeVariable", "value", "isExternal", "typeParameter", "addPotentiallyCapturedTypeParameter", "param", "seeType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1#2:357\n865#3,2:358\n865#3,2:360\n1869#3,2:362\n1869#3,2:364\n1869#3,2:366\n*S KotlinDebug\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder\n*L\n115#1:358,2\n116#1:360,2\n157#1:362,2\n158#1:364,2\n161#1:366,2\n*E\n"})
    public static final class ClosureBuilder {
        @NotNull
        private final IrDeclaration owner;
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        @NotNull
        private final Set<IrValueDeclaration> declaredValues;
        @NotNull
        private final Set<ClosureBuilder> includes;
        @NotNull
        private final Set<IrTypeParameter> potentiallyCapturedTypeParameters;
        @NotNull
        private final Set<IrTypeParameter> capturedTypeParameters;
        @Nullable
        private Closure closure;

        public ClosureBuilder(@NotNull IrDeclaration owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
            this.capturedValues = new LinkedHashSet();
            this.declaredValues = new LinkedHashSet();
            this.includes = new LinkedHashSet();
            this.potentiallyCapturedTypeParameters = new LinkedHashSet();
            this.capturedTypeParameters = new LinkedHashSet();
        }

        @NotNull
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        @NotNull
        public final Closure buildClosure() {
            boolean changes;
            Closure closure = this.closure;
            if (closure != null) {
                Closure it = closure;
                boolean bl = false;
                return it;
            }
            List<ClosureBuilder> work = this.collectConnectedClosures();
            do {
                changes = false;
                for (ClosureBuilder c : work) {
                    if (!c.updateFromIncluded()) continue;
                    changes = true;
                }
            } while (changes);
            for (ClosureBuilder c : work) {
                c.closure = new Closure(CollectionsKt.toList((Iterable)c.capturedValues), CollectionsKt.toList((Iterable)c.capturedTypeParameters));
            }
            Closure closure2 = this.closure;
            if (closure2 == null) {
                throw new AssertionError((Object)("Closure should have been built for " + RenderIrElementKt.render$default(this.owner, null, 1, null)));
            }
            return closure2;
        }

        private final List<ClosureBuilder> collectConnectedClosures() {
            LinkedHashSet<ClosureBuilder> connected = new LinkedHashSet<ClosureBuilder>();
            connected.add(this);
            ClosureBuilder.collectConnectedClosures$collectRec(connected, this);
            return CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)connected));
        }

        private final boolean updateFromIncluded() {
            if (this.closure != null) {
                throw new AssertionError((Object)("Closure has already been built for " + RenderIrElementKt.render$default(this.owner, null, 1, null)));
            }
            int capturedValuesBefore = this.capturedValues.size();
            int capturedTypeParametersBefore = this.capturedTypeParameters.size();
            for (ClosureBuilder subClosure : this.includes) {
                Object it;
                Iterable $this$filterTo$iv;
                Iterable iterable = subClosure.capturedValues;
                Collection destination$iv = this.capturedValues;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrValueSymbol)element$iv;
                    boolean bl = false;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterTo$iv = subClosure.capturedTypeParameters;
                destination$iv = this.capturedTypeParameters;
                $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    if (!this.isExternal((IrTypeParameter)it)) continue;
                    destination$iv.add(element$iv);
                }
            }
            return this.capturedValues.size() != capturedValuesBefore || this.capturedTypeParameters.size() != capturedTypeParametersBefore;
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkNotNullParameter((Object)includingBuilder, (String)"includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
                this.seeType(valueDeclaration.getType());
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (this.isExternal(value.getOwner())) {
                this.capturedValues.add(value);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        public final boolean isExternal(@NotNull IrTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            return this.potentiallyCapturedTypeParameters.contains(typeParameter);
        }

        public final void addPotentiallyCapturedTypeParameter(@NotNull IrTypeParameter param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.potentiallyCapturedTypeParameters.add(param);
        }

        public final void seeType(@NotNull IrType type) {
            block5: {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (!(type instanceof IrSimpleType)) {
                    return;
                }
                IrClassifierSymbol classifier = ((IrSimpleType)type).getClassifier();
                if (classifier instanceof IrTypeParameterSymbol && this.isExternal((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()) && this.capturedTypeParameters.add((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner())) {
                    $this$forEach$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrType p0 = (IrType)element$iv;
                        boolean bl = false;
                        this.seeType(p0);
                    }
                }
                $this$forEach$iv = ((IrSimpleType)type).getArguments();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (irTypeProjection == null || (irTypeProjection = irTypeProjection.getType()) == null) continue;
                    IrTypeProjection p0 = irTypeProjection;
                    boolean bl2 = false;
                    this.seeType((IrType)p0);
                }
                Object object = ((IrSimpleType)type).getAbbreviation();
                if (object == null || (object = object.getArguments()) == null) break block5;
                Iterable $this$forEach$iv2 = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (irTypeProjection == null || (irTypeProjection = irTypeProjection.getType()) == null) continue;
                    IrTypeProjection p0 = irTypeProjection;
                    boolean bl3 = false;
                    this.seeType((IrType)p0);
                }
            }
        }

        private static final void collectConnectedClosures$collectRec(LinkedHashSet<ClosureBuilder> connected, ClosureBuilder current) {
            for (ClosureBuilder included : current.includes) {
                if (included.closure != null || !connected.add(included)) continue;
                ClosureBuilder.collectConnectedClosures$collectRec(connected, included);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00192\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u001f2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020!2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\"\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020#2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010$\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010%\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "visitValueAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "visitRichPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichPropertyReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "processScriptCapturing", "processMemberAccess", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "parentClosure", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nClosureAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClosureAnnotator.kt\norg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n1#2:357\n*E\n"})
    private final class ClosureCollectorVisitor
    extends IrVisitor<Unit, ClosureBuilder> {
        @Override
        public void visitElement(@NotNull IrElement element, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            declaration.acceptChildren(this, ClosureAnnotator.this.getClosureBuilder(declaration));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            ClosureBuilder closureBuilder = ClosureAnnotator.this.getClosureBuilder(declaration);
            declaration.acceptChildren(this, closureBuilder);
            ClosureAnnotator.this.includeInParent(closureBuilder);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            for (IrType superType : declaration.getSuperTypes()) {
                ClosureBuilder closureBuilder = data;
                if (closureBuilder == null) continue;
                closureBuilder.seeType(superType);
            }
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.seeVariable(expression.getSymbol());
            }
            super.visitValueAccess(expression, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.declareVariable(declaration);
            }
            super.visitVariable(declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitFunctionAccess(expression, data);
            this.processScriptCapturing(expression, data);
            this.processMemberAccess(((IrFunctionSymbol)expression.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitFunctionReference(expression, data);
            this.processMemberAccess(((IrFunctionSymbol)expression.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitFunctionExpression(expression, data);
            this.processMemberAccess(expression.getFunction(), data);
        }

        @Override
        public void visitRichFunctionReference(@NotNull IrRichFunctionReference expression, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitRichFunctionReference(expression, data);
            this.processMemberAccess(expression.getInvokeFunction(), data);
        }

        @Override
        public void visitRichPropertyReference(@NotNull IrRichPropertyReference expression, @Nullable ClosureBuilder data) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitRichPropertyReference(expression, data);
                this.processMemberAccess(expression.getGetterFunction(), data);
                IrSimpleFunction irSimpleFunction = expression.getSetterFunction();
                if (irSimpleFunction == null) break block0;
                IrSimpleFunction it = irSimpleFunction;
                boolean bl = false;
                this.processMemberAccess(it, data);
            }
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable ClosureBuilder data) {
            block1: {
                IrSimpleFunctionSymbol it;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitPropertyReference(expression, data);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression.getGetter();
                if (irSimpleFunctionSymbol != null) {
                    it = irSimpleFunctionSymbol;
                    boolean bl = false;
                    this.processMemberAccess(it.getOwner(), data);
                }
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression.getSetter();
                if (irSimpleFunctionSymbol2 == null) break block1;
                it = irSimpleFunctionSymbol2;
                boolean bl = false;
                this.processMemberAccess(it.getOwner(), data);
            }
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression, @Nullable ClosureBuilder data) {
            block3: {
                ClosureBuilder typeParameterContainerScopeBuilder;
                Object object;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitExpression(expression, data);
                ClosureBuilder closureBuilder = data;
                if (closureBuilder != null) {
                    ClosureBuilder closureBuilder2 = closureBuilder;
                    ClosureAnnotator closureAnnotator = ClosureAnnotator.this;
                    ClosureBuilder it = closureBuilder2;
                    boolean bl = false;
                    IrDeclaration irDeclaration = it.getOwner();
                    object = irDeclaration instanceof IrConstructor ? (IrConstructor)irDeclaration : null;
                    if (object == null || (object = closureAnnotator.getClosureBuilder((IrFunction)object)) == null) {
                        object = it;
                    }
                } else {
                    object = null;
                }
                ClosureBuilder closureBuilder3 = typeParameterContainerScopeBuilder = object;
                if (closureBuilder3 == null) break block3;
                closureBuilder3.seeType(expression.getType());
            }
        }

        private final void processScriptCapturing(IrFunctionAccessExpression expression, ClosureBuilder data) {
            block1: {
                IrDeclarationParent irDeclarationParent;
                IrDeclarationParent parent;
                block2: {
                    IrFunction declaration = ((IrFunctionSymbol)expression.getSymbol()).getOwner();
                    if (!ClosureAnnotator.this.scriptingMode || declaration.getDispatchReceiverParameter() != null && expression.getArguments().size() >= declaration.getParameters().size()) break block1;
                    parent = declaration.getParent();
                    irDeclarationParent = parent;
                    if (!(irDeclarationParent instanceof IrScript)) break block2;
                    ClosureBuilder closureBuilder = data;
                    if (closureBuilder == null) break block1;
                    IrValueParameter irValueParameter = ((IrScript)parent).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    closureBuilder.seeVariable(irValueParameter.getSymbol());
                    break block1;
                }
                if (!(irDeclarationParent instanceof IrClass) || !Intrinsics.areEqual((Object)((IrClass)parent).getOrigin(), (Object)IrDeclarationOrigin.Companion.getSCRIPT_CLASS()) && !Intrinsics.areEqual((Object)((IrClass)parent).getOrigin(), (Object)IrDeclarationOrigin.Companion.getREPL_FROM_OTHER_SNIPPET())) break block1;
                ClosureBuilder closureBuilder = data;
                if (closureBuilder != null) {
                    IrValueParameter irValueParameter = ((IrClass)parent).getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    closureBuilder.seeVariable(irValueParameter.getSymbol());
                }
            }
        }

        private final void processMemberAccess(IrDeclaration declaration, ClosureBuilder parentClosure) {
            block3: {
                ClosureBuilder builder;
                if (!AdditionalIrUtilsKt.isLocal(declaration)) break block3;
                if (declaration instanceof IrSimpleFunction && !Intrinsics.areEqual((Object)((IrSimpleFunction)declaration).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                    return;
                }
                ClosureBuilder closureBuilder = builder = ClosureAnnotator.this.getClosureBuilderOrNull(declaration);
                if (closureBuilder != null) {
                    ClosureBuilder it = closureBuilder;
                    boolean bl = false;
                    ClosureBuilder closureBuilder2 = parentClosure;
                    if (closureBuilder2 != null) {
                        closureBuilder2.include(builder);
                    }
                }
            }
        }
    }
}

