/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.resources.admin.fgap.ClientPermissions;
import org.keycloak.services.resources.admin.fgap.FineGrainedAdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.MgmtPermissionsV2;
import org.keycloak.services.resources.admin.fgap.ModelRecord;

class ClientPermissionsV2
extends ClientPermissions {
    private final FineGrainedAdminPermissionEvaluator eval;

    ClientPermissionsV2(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissionsV2 root) {
        super(session, realm, authz, root);
        this.eval = new FineGrainedAdminPermissionEvaluator(session, root, this.resourceStore, this.policyStore);
    }

    @Override
    public boolean canList() {
        return this.root.hasOneAdminRole("query-clients") || this.canView();
    }

    @Override
    public void requireConfigure(ClientModel client) {
        super.requireManage(client);
    }

    @Override
    public boolean canConfigure(ClientModel client) {
        return this.canManage(client);
    }

    @Override
    public boolean canManage(ClientModel client) {
        if (this.root.hasOneAdminRole("manage-clients")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(client), null, "manage");
    }

    @Override
    public boolean canManage() {
        if (this.root.hasOneAdminRole("manage-clients")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(null), null, "manage");
    }

    @Override
    public boolean canView(ClientModel client) {
        if (this.root.hasOneAdminRole("manage-clients", "view-clients")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(client), null, "view");
    }

    @Override
    public boolean canView() {
        if (this.root.hasOneAdminRole("manage-clients", "view-clients")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(null), null, "view");
    }

    @Override
    public boolean canMapRoles(ClientModel client) {
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(client), null, "map-roles");
    }

    @Override
    public boolean canMapCompositeRoles(ClientModel client) {
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(client), null, "map-roles-composite");
    }

    @Override
    public boolean canMapClientScopeRoles(ClientModel client) {
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(client), null, "map-roles-client-scope");
    }

    @Override
    public boolean canManageClientScopes() {
        if (this.root.hasOneAdminRole("manage-clients")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(null), null, "manage");
    }

    @Override
    public boolean canManage(ClientScopeModel clientScope) {
        return this.canManageClientScopes();
    }

    @Override
    public boolean canView(ClientScopeModel clientScope) {
        if (this.root.hasOneAdminRole("view-clients", "manage-clients")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.ClientModelRecord(null), null, "view");
    }

    @Override
    public Set<String> getClientIdsByScope(String scope) {
        return this.eval.getIdsByScope("Clients", scope);
    }

    @Override
    public boolean canExchangeTo(ClientModel authorizedClient, ClientModel to, AccessToken token) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy exchangeToPermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesPermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesClientScopePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesCompositePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy managePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy configurePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewPermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isPermissionsEnabled(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(ClientModel client, boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }
}

